/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.fusesource.rmiviajms.internal.JMSRemoteRef;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;
import org.fusesource.rmiviajms.internal.JMSTemplate;
import org.fusesource.rmiviajms.internal.Request;
import org.fusesource.rmiviajms.internal.Response;
import org.fusesource.rmiviajms.internal.Skeleton;

class ExplictDestinationSkeleton
extends Skeleton
implements Runnable {
    private JMSRemoteSystem remoteSystem;
    private final JMSTemplate template;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final JMSRemoteRef ref;
    Thread receiveThread;

    ExplictDestinationSkeleton(JMSRemoteSystem remoteSystem, JMSRemoteRef ref, Object target) {
        super(remoteSystem, ref, target);
        this.remoteSystem = remoteSystem;
        this.template = new JMSTemplate(remoteSystem);
        this.ref = ref;
    }

    public void start() throws JMSException, JMSTemplate.TemplateClosedException {
        if (this.receiveThread == null) {
            this.running.set(true);
            this.template.getMessageConsumer(this.ref.getDestination());
            this.receiveThread = new Thread(this);
            this.receiveThread.setName("RMI via JMS: receiver");
            this.receiveThread.setDaemon(true);
            this.receiveThread.start();
        }
    }

    public Response invoke(Request request) {
        return super.invoke(request);
    }

    public void stop() throws InterruptedException {
        if (this.receiveThread != null) {
            this.running.set(false);
            this.receiveThread.join();
            this.receiveThread = null;
        }
    }

    public void run() {
        while (this.running.get()) {
            try {
                Session session = this.template.getSession();
                MessageConsumer consumer = this.template.getMessageConsumer(this.ref.getDestination());
                Message msg = consumer.receive(500L);
                if (msg == null) continue;
                if ("rmi:request".equals(msg.getJMSType())) {
                    this.remoteSystem.getDispatchThreads().execute(new DispatchTask((ObjectMessage)msg, false));
                    continue;
                }
                if (!"rmi:oneway".equals(msg.getJMSType())) continue;
                this.remoteSystem.getDispatchThreads().execute(new DispatchTask((ObjectMessage)msg, true));
            }
            catch (JMSTemplate.TemplateClosedException tce) {
                tce.printStackTrace();
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.template.reset();
            }
        }
    }

    private class DispatchTask
    implements Runnable {
        private final ObjectMessage msg;
        private final boolean oneway;

        public DispatchTask(ObjectMessage msg, boolean oneway) {
            this.msg = msg;
            this.oneway = oneway;
        }

        public void run() {
            try {
                Thread.currentThread().setContextClassLoader(ExplictDestinationSkeleton.this.getTargetClassLoader());
                Request request = (Request)this.msg.getObject();
                Response response = ExplictDestinationSkeleton.this.invoke(request);
                if (!this.oneway) {
                    ExplictDestinationSkeleton.this.remoteSystem.sendResponse((Message)this.msg, response);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

