/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jms.Destination;
import org.fusesource.rmiviajms.Oneway;
import org.fusesource.rmiviajms.internal.CGLibProxyAdapter;
import org.fusesource.rmiviajms.internal.JMSRemoteObjectInvocationHandler;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMSRemoteRef
implements RemoteRef {
    private static final HashSet<Class<? extends Annotation>> ONE_WAY_ANNOTATIONS = new HashSet();
    private Destination destination;
    private long objectId;
    private Class<?> superclass;
    private Class<?>[] interfaces;
    private boolean isRemote;
    private transient Remote proxy;

    public void initializeNonRemote(Class<?> clazz, Class<?>[] interfaces, Destination destination, long objectId) throws Exception {
        this.destination = destination;
        this.objectId = objectId;
        this.isRemote = false;
        if (interfaces != null && interfaces.length > 0) {
            for (Class<?> c : interfaces) {
                if (!c.isAssignableFrom(clazz)) {
                    throw new RemoteException("Invalid proxy interface " + clazz.getName() + " not assignable to " + c.getName());
                }
                if (!c.isInterface()) {
                    throw new IllegalArgumentException("Not an interface: " + c);
                }
                JMSRemoteRef.validateRemoteInterface(c, false);
            }
            this.interfaces = new Class[interfaces.length + 1];
            System.arraycopy(interfaces, 0, this.interfaces, 0, interfaces.length);
            this.interfaces[this.interfaces.length - 1] = Remote.class;
            this.proxy = (Remote)Proxy.newProxyInstance(clazz.getClassLoader(), this.interfaces, this.createInvocationHandler());
        } else {
            for (Method m : clazz.getDeclaredMethods()) {
                JMSRemoteRef.validateRemoteMethod(m, false);
            }
            this.superclass = clazz;
            this.interfaces = new Class[]{Remote.class};
            this.proxy = (Remote)CGLibProxyAdapter.newProxyInstance(clazz, this.interfaces, this.createInvocationHandler());
        }
    }

    public void initialize(Class<? extends Remote> clazz, Destination destination, long objectId) throws RemoteException {
        this.destination = destination;
        this.objectId = objectId;
        this.isRemote = true;
        this.initialize(clazz);
    }

    private void initialize(Class<? extends Remote> clazz) throws RemoteException {
        LinkedHashSet rc = new LinkedHashSet();
        JMSRemoteRef.collectRemoteInterfaces(clazz, rc);
        if (rc.isEmpty()) {
            throw new ExportException("No remote interfaces found.");
        }
        this.interfaces = new Class[rc.size()];
        rc.toArray(this.interfaces);
        this.proxy = (Remote)Proxy.newProxyInstance(clazz.getClassLoader(), this.interfaces, this.createInvocationHandler());
    }

    private InvocationHandler createInvocationHandler() {
        if (this.isRemote) {
            return new RemoteObjectInvocationHandler(this);
        }
        return new JMSRemoteObjectInvocationHandler(this);
    }

    private void initialize(List<Class<?>> interfaces, Destination destination, boolean validateRemote) throws RemoteException {
        this.destination = destination;
        this.objectId = -1L;
        this.interfaces = new Class[interfaces.size()];
        interfaces.toArray(this.interfaces);
        this.proxy = (Remote)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), this.interfaces, this.createInvocationHandler());
    }

    public Remote getProxy() {
        return this.proxy;
    }

    public static void addOneWayAnnotation(Class<? extends Annotation> annotation) {
        ONE_WAY_ANNOTATIONS.add(annotation);
    }

    static boolean isOneWay(Method method) {
        for (Class<? extends Annotation> annotation : ONE_WAY_ANNOTATIONS) {
            if (!method.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static <T> T toProxy(String destination, Class<T> mainClass, Class<?> ... extraInterface) throws RemoteException {
        if (mainClass == null) {
            throw new IllegalArgumentException("mainClass cannot be null.");
        }
        JMSRemoteRef ref = new JMSRemoteRef();
        ArrayList list = new ArrayList(extraInterface.length + 1);
        list.add(mainClass);
        if (extraInterface != null) {
            list.addAll(Arrays.asList(extraInterface));
        }
        for (Class clazz : list) {
            if (clazz.isInterface()) continue;
            throw new IllegalArgumentException("Not an interface: " + clazz);
        }
        if (!list.contains(Remote.class)) {
            list.add(Remote.class);
        }
        ref.initialize(list, JMSRemoteSystem.createDestination(destination), false);
        return (T)ref.getProxy();
    }

    public static boolean isRemoteProxy(Object obj) {
        return JMSRemoteRef.getProxyInvocationHandler(obj) != null;
    }

    private static RemoteObjectInvocationHandler getProxyInvocationHandler(Object obj) {
        InvocationHandler handler = null;
        if (Proxy.isProxyClass(obj.getClass())) {
            handler = Proxy.getInvocationHandler(obj);
        } else if (CGLibProxyAdapter.isProxyClass(obj.getClass())) {
            handler = CGLibProxyAdapter.getInvocationHandler(obj);
        }
        if (handler instanceof RemoteObjectInvocationHandler) {
            return (RemoteObjectInvocationHandler)handler;
        }
        return null;
    }

    public static JMSRemoteRef getJMSRemoteRefFromProxy(Remote obj) {
        RemoteObjectInvocationHandler handler = JMSRemoteRef.getProxyInvocationHandler(obj);
        if (handler != null) {
            return (JMSRemoteRef)handler.getRef();
        }
        return null;
    }

    private static void collectRemoteInterfaces(Class<?> clazz, Set<Class<?>> rc) throws RemoteException {
        for (Class<?> interf : clazz.getInterfaces()) {
            if (!Remote.class.isAssignableFrom(interf)) continue;
            JMSRemoteRef.validateRemoteInterface(interf, true);
            rc.add(interf);
        }
        if (clazz.getSuperclass() != null) {
            JMSRemoteRef.collectRemoteInterfaces(clazz.getSuperclass(), rc);
        }
    }

    private static void validateRemoteInterface(Class<?> intf, boolean isRemote) throws RemoteException {
        for (Method method : intf.getMethods()) {
            JMSRemoteRef.validateRemoteMethod(method, isRemote);
        }
    }

    private static void validateRemoteMethod(Method method, boolean isRemote) throws RemoteException {
        if (isRemote) {
            boolean throwsRemoteException = false;
            for (Class<RemoteException> clazz : method.getExceptionTypes()) {
                if (!RemoteException.class.isAssignableFrom(clazz) && !clazz.isAssignableFrom(RemoteException.class)) continue;
                throwsRemoteException = true;
                break;
            }
            if (!throwsRemoteException) {
                throw new ExportException("Invalid Remote interface " + method.getDeclaringClass().getName() + " method " + method.getName() + " does not throw a RemoteException");
            }
        }
        if (JMSRemoteRef.isOneWay(method) && method.getReturnType() != Void.TYPE) {
            throw new ExportException("Invalid remote class " + method.getDeclaringClass().getName() + " method " + method.getName() + " is annotated as OneWay so it must return void");
        }
    }

    @Override
    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        return JMSRemoteSystem.INSTANCE.invoke(this, method, params);
    }

    @Override
    public String getRefClass(ObjectOutput out) {
        return null;
    }

    @Override
    public int remoteHashCode() {
        return this.destination.hashCode() ^ new Long(this.objectId).hashCode();
    }

    @Override
    public boolean remoteEquals(RemoteRef obj) {
        if (obj.getClass() != JMSRemoteRef.class) {
            return false;
        }
        JMSRemoteRef other = (JMSRemoteRef)obj;
        return other.objectId == this.objectId && other.destination.equals(this.destination);
    }

    @Override
    public String remoteToString() {
        return this.destination + ":" + this.objectId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.destination);
        out.writeBoolean(this.isRemote);
        out.writeLong(this.objectId);
        boolean isCGProxy = CGLibProxyAdapter.isProxyClass(this.proxy.getClass());
        out.writeBoolean(isCGProxy);
        if (isCGProxy) {
            out.writeUTF(this.superclass.getName());
        }
        out.writeShort(this.interfaces.length);
        for (Class<?> i : this.interfaces) {
            out.writeUTF(i.getName());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.destination = (Destination)in.readObject();
        this.isRemote = in.readBoolean();
        this.objectId = in.readLong();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        boolean isCGProxy = in.readBoolean();
        if (isCGProxy) {
            this.superclass = cl.loadClass(in.readUTF());
        }
        this.interfaces = new Class[in.readShort()];
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = cl.loadClass(in.readUTF());
        }
        this.proxy = !isCGProxy ? (Remote)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), this.interfaces, this.createInvocationHandler()) : (Remote)CGLibProxyAdapter.newProxyInstance(this.superclass, this.interfaces, this.createInvocationHandler());
    }

    @Override
    @Deprecated
    public RemoteCall newCall(RemoteObject obj, Operation[] op, int opnum, long hash) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void invoke(RemoteCall call) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void done(RemoteCall call) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public Destination getDestination() {
        return this.destination;
    }

    static {
        ONE_WAY_ANNOTATIONS.add(Oneway.class);
    }
}

