/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.fusesource.rmiviajms.JMSRemoteObject;
import org.fusesource.rmiviajms.Persistent;
import org.fusesource.rmiviajms.Priority;
import org.fusesource.rmiviajms.Timeout;
import org.fusesource.rmiviajms.internal.DispatchTask;
import org.fusesource.rmiviajms.internal.ExplictDestinationSkeleton;
import org.fusesource.rmiviajms.internal.JMSRemoteRef;
import org.fusesource.rmiviajms.internal.JMSTemplate;
import org.fusesource.rmiviajms.internal.RequestExchange;
import org.fusesource.rmiviajms.internal.Response;
import org.fusesource.rmiviajms.internal.Skeleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMSRemoteSystem {
    public static final String REMOTE_SYSTEM_CLASS = System.getProperty("org.fusesource.rmiviajms.REMOTE_SYSTEM_CLASS", "org.fusesource.rmiviajms.internal.ActiveMQRemoteSystem");
    public static final long REQUEST_TIMEOUT = new Long(System.getProperty("org.fusesource.rmiviajms.REQUEST_TIMEOUT", "9223372036854775807"));
    protected static final String MSG_TYPE_ONEWAY = "rmi:oneway";
    protected static final String MSG_TYPE_REQUEST = "rmi:request";
    protected static final String MSG_TYPE_RESPONSE = "rmi:response";
    protected static final String MSG_PROP_REQUEST = "request";
    protected static final String MSG_PROP_OBJECT = "object";
    public static final JMSRemoteSystem INSTANCE = JMSRemoteSystem.createJMSRemoteSystem();
    public ClassLoader userClassLoader;
    protected final ConcurrentHashMap<RemoteIdentity, JMSRemoteRef> exportedRemoteRefs = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Long, Skeleton> exportedSkeletonsById = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Long, RequestExchange> requests = new ConcurrentHashMap();
    protected final AtomicLong objectCounter = new AtomicLong(0L);
    protected final AtomicLong requestCounter = new AtomicLong(0L);
    protected final AtomicBoolean running = new AtomicBoolean(true);
    protected JMSTemplate sendTemplate = new JMSTemplate(this);
    protected JMSTemplate receiveTemplate = new JMSTemplate(this);
    protected ExecutorService senderThread;
    protected ExecutorService dispatchThreads;
    protected Thread receiveThread;
    protected String systemId;

    public void setUserClassLoader(ClassLoader userClassLoader) {
        this.userClassLoader = userClassLoader;
    }

    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    public ClassLoader getUserClassLoader(Object o) {
        if (this.userClassLoader != null) {
            return this.userClassLoader;
        }
        if (o != null) {
            return o.getClass().getClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws InterruptedException {
        this.running.set(false);
        JMSRemoteSystem jMSRemoteSystem = this;
        synchronized (jMSRemoteSystem) {
            Object entry;
            this.sendTemplate.close();
            this.receiveTemplate.close();
            if (this.senderThread != null) {
                this.senderThread.shutdown();
                this.senderThread.awaitTermination(30L, TimeUnit.SECONDS);
            }
            if (this.receiveThread != null) {
                this.receiveThread.join(30000L);
            }
            if (this.dispatchThreads != null) {
                this.dispatchThreads.shutdown();
                this.dispatchThreads.awaitTermination(30L, TimeUnit.SECONDS);
            }
            this.senderThread = null;
            this.receiveThread = null;
            this.dispatchThreads = null;
            this.systemId = null;
            Iterator<Object> iterator = this.exportedSkeletonsById.values().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (entry instanceof ExplictDestinationSkeleton) {
                    ((ExplictDestinationSkeleton)entry).stop();
                }
                iterator.remove();
            }
            iterator = this.requests.values().iterator();
            while (iterator.hasNext()) {
                entry = (RequestExchange)iterator.next();
                ((RequestExchange)entry).cancel();
                iterator.remove();
            }
            this.exportedRemoteRefs.clear();
            this.exportedSkeletonsById.clear();
            this.objectCounter.set(0L);
            this.requestCounter.set(0L);
            this.sendTemplate = new JMSTemplate(this);
            this.receiveTemplate = new JMSTemplate(this);
        }
        this.running.set(true);
    }

    public synchronized String getSystemId() {
        if (this.systemId == null) {
            this.systemId = JMSRemoteSystem.createJVMID();
        }
        return this.systemId;
    }

    public void exportNonRemote(Object obj, Class<?>[] interfaces, JMSRemoteRef ref) throws Exception {
        ref.initializeNonRemote(obj.getClass(), interfaces, this.receiveTemplate.getLocalSystemQueue(), this.objectCounter.incrementAndGet());
        this.exportedSkeletonsById.put(ref.getObjectId(), new Skeleton(this, ref, obj));
        this.exportedRemoteRefs.put(new RemoteIdentity(obj), ref);
        this.kickReceiveThread();
    }

    public void exportNonRemote(Object obj, Class<?>[] interfaces, String destination, JMSRemoteRef ref) throws Exception {
        ref.initializeNonRemote(obj.getClass(), interfaces, JMSRemoteSystem.createDestination(destination), this.objectCounter.incrementAndGet());
        ExplictDestinationSkeleton skeleton = new ExplictDestinationSkeleton(this, ref, obj);
        this.exportedSkeletonsById.put(ref.getObjectId(), skeleton);
        this.exportedRemoteRefs.put(new RemoteIdentity(obj), ref);
        try {
            skeleton.start();
        }
        catch (Exception e) {
            throw new RemoteException("Error exporting object", e);
        }
    }

    public void export(JMSRemoteRef ref, Remote obj) throws RemoteException {
        ref.initialize(obj.getClass(), this.receiveTemplate.getLocalSystemQueue(), this.objectCounter.incrementAndGet());
        this.exportedSkeletonsById.put(ref.getObjectId(), new Skeleton(this, ref, obj));
        this.exportedRemoteRefs.put(new RemoteIdentity(obj), ref);
        try {
            this.kickReceiveThread();
        }
        catch (JMSTemplate.TemplateClosedException tce) {
            throw new RemoteException("RemoteSystem reset", tce);
        }
    }

    public void export(JMSRemoteRef ref, Remote obj, String destination) throws RemoteException {
        ref.initialize(obj.getClass(), JMSRemoteSystem.createDestination(destination), this.objectCounter.incrementAndGet());
        ExplictDestinationSkeleton skeleton = new ExplictDestinationSkeleton(this, ref, obj);
        this.exportedSkeletonsById.put(ref.getObjectId(), skeleton);
        this.exportedRemoteRefs.put(new RemoteIdentity(obj), ref);
        try {
            skeleton.start();
        }
        catch (Exception e) {
            throw new RemoteException("Error exporting object", e);
        }
    }

    public JMSRemoteRef getExportedRemoteRef(Remote obj) throws NoSuchObjectException {
        if (JMSRemoteRef.isRemoteProxy(obj)) {
            return JMSRemoteRef.getJMSRemoteRefFromProxy(obj);
        }
        JMSRemoteRef ref = this.exportedRemoteRefs.get(new RemoteIdentity(obj));
        if (ref == null) {
            throw new NoSuchObjectException("Object not exported: " + obj);
        }
        return ref;
    }

    public boolean unexport(Remote obj, boolean force) throws InterruptedException, NoSuchObjectException {
        JMSRemoteRef ref = this.getExportedRemoteRef(obj);
        Skeleton skeleton = this.exportedSkeletonsById.remove(ref.getObjectId());
        if (skeleton == null) {
            throw new NoSuchObjectException("Object not exported: " + obj);
        }
        this.exportedRemoteRefs.remove(new RemoteIdentity(skeleton.target));
        if (skeleton instanceof ExplictDestinationSkeleton) {
            ((ExplictDestinationSkeleton)skeleton).stop();
        }
        return true;
    }

    public Object invoke(JMSRemoteRef jmsRemoteRef, Method method, Object[] params) throws Exception {
        boolean oneway = JMSRemoteRef.isOneWay(method);
        long timeout = 0L;
        if (!oneway) {
            Long nto;
            timeout = REQUEST_TIMEOUT;
            if (method.isAnnotationPresent(Timeout.class)) {
                timeout = method.getAnnotation(Timeout.class).value();
            }
            if ((nto = JMSRemoteObject.removeNextInvocationTimeout()) != null) {
                timeout = nto;
            }
            this.kickReceiveThread();
        }
        int deliveryMode = method.isAnnotationPresent(Persistent.class) ? 2 : 1;
        int priority = 4;
        if (method.isAnnotationPresent(Priority.class)) {
            priority = method.getAnnotation(Priority.class).value();
        }
        RequestExchange requestExchange = new RequestExchange(this, jmsRemoteRef, JMSRemoteSystem.signature(method), params, oneway, timeout, deliveryMode, priority);
        this.getSenderThread().execute(requestExchange);
        try {
            return requestExchange.getResult();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RemoteException("Unexepected error", e);
        }
    }

    private void receiveAndDispatch() throws Exception {
        block9: {
            try {
                Session session = this.receiveTemplate.getSession();
                MessageConsumer consumer = this.receiveTemplate.getMessageConsumer();
                Message msg = consumer.receive(500L);
                if (msg == null) break block9;
                if (MSG_TYPE_REQUEST.equals(msg.getJMSType())) {
                    this.getDispatchThreads().execute(new DispatchTask(this, (ObjectMessage)msg, false));
                    break block9;
                }
                if (MSG_TYPE_ONEWAY.equals(msg.getJMSType())) {
                    this.getDispatchThreads().execute(new DispatchTask(this, (ObjectMessage)msg, true));
                    break block9;
                }
                if (!MSG_TYPE_RESPONSE.equals(msg.getJMSType())) break block9;
                try {
                    long request = msg.getLongProperty(MSG_PROP_REQUEST);
                    RequestExchange target = this.requests.remove(request);
                    if (target == null) break block9;
                    Response response = null;
                    try {
                        Thread.currentThread().setContextClassLoader(this.getUserClassLoader(target));
                        response = (Response)((ObjectMessage)msg).getObject();
                        response.fromRemote = true;
                    }
                    catch (JMSException e) {
                        target.setResponse(new Response(request, null, new UnmarshalException("Could not unmarshall response: " + e.getMessage(), (Exception)((Object)e))));
                    }
                    target.setResponse(response);
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            catch (JMSTemplate.TemplateClosedException tce) {
                tce.printStackTrace();
                throw tce;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.receiveTemplate.reset();
                throw e;
            }
        }
    }

    void sendResponse(final Message requestMessage, final Response response) {
        this.getSenderThread().execute(new Runnable(){

            public void run() {
                ObjectMessage msg = null;
                while (JMSRemoteSystem.this.running.get()) {
                    try {
                        Session session = JMSRemoteSystem.this.sendTemplate.getSession();
                        MessageProducer producer = JMSRemoteSystem.this.sendTemplate.getMessageProducer();
                        if (msg == null) {
                            try {
                                msg = session.createObjectMessage((Serializable)response);
                            }
                            catch (JMSException e) {
                                msg = session.createObjectMessage((Serializable)new Response(response.requestId, null, new MarshalException("Could not marshall response: " + e.getMessage(), (Exception)((Object)e))));
                            }
                        }
                        msg.setLongProperty(JMSRemoteSystem.MSG_PROP_REQUEST, response.requestId);
                        msg.setJMSType(JMSRemoteSystem.MSG_TYPE_RESPONSE);
                        producer.send(requestMessage.getJMSReplyTo(), (Message)msg, requestMessage.getJMSDeliveryMode(), requestMessage.getJMSPriority(), 0L);
                        return;
                    }
                    catch (JMSTemplate.TemplateClosedException tce) {
                        tce.printStackTrace();
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JMSRemoteSystem.this.sendTemplate.reset();
                    }
                }
            }
        });
    }

    protected abstract ConnectionFactory createConnectionFactory();

    protected abstract Destination createQueue(String var1);

    protected abstract Destination createTopic(String var1);

    synchronized ExecutorService getDispatchThreads() {
        if (this.dispatchThreads == null) {
            this.dispatchThreads = Executors.newCachedThreadPool(this.threadFactory("RMI via JMS: service"));
        }
        return this.dispatchThreads;
    }

    synchronized ExecutorService getSenderThread() {
        if (this.senderThread == null) {
            this.senderThread = Executors.newSingleThreadExecutor(this.threadFactory("RMI via JMS: sender"));
        }
        return this.senderThread;
    }

    synchronized Thread kickReceiveThread() throws JMSTemplate.TemplateClosedException {
        if (this.receiveThread == null) {
            while (true) {
                try {
                    this.receiveTemplate.getMessageConsumer();
                }
                catch (JMSException e1) {
                    this.receiveTemplate.reset();
                    continue;
                }
                break;
            }
            this.receiveThread = new Thread(){

                public void run() {
                    while (JMSRemoteSystem.this.running.get()) {
                        try {
                            JMSRemoteSystem.this.receiveAndDispatch();
                        }
                        catch (JMSTemplate.TemplateClosedException tce) {
                            return;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            };
            this.receiveThread.setName("RMI via JMS: receiver");
            this.receiveThread.setDaemon(true);
            this.receiveThread.start();
        }
        return this.receiveThread;
    }

    private ThreadFactory threadFactory(final String name) {
        return new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(name);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    private static String createJVMID() {
        String name = System.getProperty("java.rmi.server.hostname");
        if (name == null) {
            try {
                name = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                name = "unknown";
            }
        }
        return name + ":" + UUID.randomUUID();
    }

    static final Destination createDestination(String destination) {
        if (destination.startsWith("multicast:")) {
            return INSTANCE.createTopic(destination.substring("multicast:".length()));
        }
        return INSTANCE.createQueue(destination);
    }

    static String signature(Method method) {
        StringBuilder sb = new StringBuilder();
        if (method.getReturnType() != null) {
            sb.append(method.getReturnType().getName());
        } else {
            sb.append("void");
        }
        sb.append(' ');
        sb.append(method.getName());
        for (Class<?> type : method.getParameterTypes()) {
            sb.append(' ');
            sb.append(type.getName());
        }
        return sb.toString();
    }

    private static JMSRemoteSystem createJMSRemoteSystem() {
        try {
            try {
                return (JMSRemoteSystem)JMSRemoteSystem.class.getClassLoader().loadClass(REMOTE_SYSTEM_CLASS).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    return (JMSRemoteSystem)cl.loadClass(REMOTE_SYSTEM_CLASS).newInstance();
                }
                throw cnfe;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid setting for the org.fusesource.rmiviajms.JMSRemoteSystem system property: " + e, e);
        }
    }

    static class RemoteIdentity {
        final Object remote;

        RemoteIdentity(Object remote) {
            this.remote = remote;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteIdentity remoteIdentity = (RemoteIdentity)o;
            return this.remote == remoteIdentity.remote;
        }

        public int hashCode() {
            return this.remote.hashCode();
        }
    }
}

