/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;

class JMSTemplate {
    private Session session;
    private Connection connection;
    private ConnectionFactory connectionFactory;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private Destination localSystemQueue;
    private JMSRemoteSystem remoteSystem;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public JMSTemplate(JMSRemoteSystem remoteSystem) {
        this.remoteSystem = remoteSystem;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Connection oldConn = null;
        JMSTemplate jMSTemplate = this;
        synchronized (jMSTemplate) {
            oldConn = this.connection;
            this.connection = null;
            if (oldConn != null) {
                this.connection = null;
                this.session = null;
                this.producer = null;
                this.consumer = null;
                this.connectionFactory = null;
                this.localSystemQueue = null;
            }
        }
        if (oldConn != null) {
            try {
                oldConn.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    Destination getLocalSystemQueue() {
        if (this.localSystemQueue == null) {
            this.localSystemQueue = this.remoteSystem.createQueue(this.remoteSystem.getSystemId());
        }
        return this.localSystemQueue;
    }

    MessageConsumer getMessageConsumer(Destination destination) throws JMSException, TemplateClosedException {
        if (this.consumer == null) {
            this.consumer = this.getSession().createConsumer(destination);
        }
        return this.consumer;
    }

    MessageConsumer getMessageConsumer() throws JMSException, TemplateClosedException {
        return this.getMessageConsumer(this.getLocalSystemQueue());
    }

    MessageProducer getMessageProducer() throws JMSException, TemplateClosedException {
        if (this.producer == null) {
            this.producer = this.getSession().createProducer(null);
        }
        return this.producer;
    }

    Session getSession() throws JMSException, TemplateClosedException {
        if (this.session == null) {
            this.session = this.getConnection().createSession(false, 1);
        }
        return this.session;
    }

    synchronized Connection getConnection() throws JMSException, TemplateClosedException {
        if (this.closed.get()) {
            throw new JMSException("JMSTemplate Closed");
        }
        if (this.connection == null) {
            this.connection = this.getConnectionFactory().createConnection();
            this.connection.setExceptionListener(new ExceptionListener(){
                final Connection thisConn;
                {
                    this.thisConn = JMSTemplate.this.connection;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onException(JMSException exception) {
                    try {
                        boolean reset = false;
                        1 var3_4 = this;
                        synchronized (var3_4) {
                            if (JMSTemplate.this.connection == this.thisConn) {
                                reset = true;
                            }
                        }
                        if (reset && !JMSTemplate.this.closed.get() && reset) {
                            JMSTemplate.this.reset();
                        }
                    }
                    catch (Throwable thrown) {
                        thrown.printStackTrace();
                    }
                }
            });
            this.connection.start();
        }
        return this.connection;
    }

    ConnectionFactory getConnectionFactory() throws JMSException {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.remoteSystem.createConnectionFactory();
        }
        return this.connectionFactory;
    }

    public class TemplateClosedException
    extends Exception {
    }
}

