/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.fusesource.rmiviajms.internal.JMSRemoteRef;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;
import org.fusesource.rmiviajms.internal.Request;
import org.fusesource.rmiviajms.internal.Response;

final class RequestExchange
implements Runnable {
    private final JMSRemoteRef remoteRef;
    private final boolean oneway;
    private final long timeout;
    private final int deliveryMode;
    private final int priority;
    private final Request request;
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private final CountDownLatch completed = new CountDownLatch(1);
    private final AtomicReference<Response> response = new AtomicReference();
    private JMSRemoteSystem remoteSystem;

    public RequestExchange(JMSRemoteSystem remoteSystem, JMSRemoteRef remoteRef, String signature, Object[] params, boolean oneway, long timeout, int deliveryMode, int priority) {
        this.remoteSystem = remoteSystem;
        this.remoteRef = remoteRef;
        this.oneway = oneway;
        this.timeout = timeout;
        this.deliveryMode = deliveryMode;
        this.priority = priority;
        this.request = new Request(remoteRef.getObjectId(), signature, params, remoteSystem.requestCounter.incrementAndGet());
    }

    public Object getResult() throws Throwable {
        if (this.timeout > 0L) {
            if (!this.completed.await(this.timeout, TimeUnit.MILLISECONDS)) {
                this.canceled.set(true);
                throw new RemoteException("request tmeout");
            }
        } else {
            this.completed.await();
        }
        Response r = this.response.get();
        if (r.exception != null) {
            if (r.fromRemote) {
                if (r.exception instanceof RemoteException) {
                    throw new ServerException(r.exception.toString(), (RemoteException)r.exception);
                }
                if (r.exception instanceof Error) {
                    throw new ServerError(r.exception.toString(), (Error)r.exception);
                }
            }
            StackTraceElement[] trace = r.exception.getStackTrace();
            ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
            newTrace.addAll(Arrays.asList(trace));
            newTrace.add(new StackTraceElement("***RMIVIAJMS", "REMOTECALL***", null, 0));
            newTrace.addAll(Arrays.asList(new Exception().getStackTrace()));
            r.exception.setStackTrace(newTrace.toArray(trace));
            throw r.exception;
        }
        return r.result;
    }

    public void setResponse(Response response) {
        this.response.compareAndSet(null, response);
        this.completed.countDown();
    }

    public void cancel() {
        this.canceled.set(true);
        this.remoteSystem.requests.remove(this.request.requestId);
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

