/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.util.HashMap;
import org.fusesource.rmiviajms.internal.CGLibProxyAdapter;
import org.fusesource.rmiviajms.internal.JMSRemoteRef;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;
import org.fusesource.rmiviajms.internal.Request;
import org.fusesource.rmiviajms.internal.Response;

class Skeleton {
    final Object target;
    private final HashMap<String, Method> methods = new HashMap();
    private final JMSRemoteSystem remoteSystem;

    public ClassLoader getTargetClassLoader() {
        return this.remoteSystem.getUserClassLoader(this.target);
    }

    Skeleton(JMSRemoteSystem remoteSystem, JMSRemoteRef ref, Object target) {
        this.remoteSystem = remoteSystem;
        try {
            this.target = target;
            Class<?> clazz = this.target.getClass();
            if (CGLibProxyAdapter.isProxyClass(ref.getProxy().getClass())) {
                for (Method method : clazz.getMethods()) {
                    if (method.getDeclaringClass() == Object.class) continue;
                    String sig = JMSRemoteSystem.signature(method);
                    this.methods.put(sig, clazz.getMethod(method.getName(), method.getParameterTypes()));
                }
            } else {
                for (Class<?> intf : ref.getInterfaces()) {
                    for (Method method : intf.getMethods()) {
                        String sig = JMSRemoteSystem.signature(method);
                        this.methods.put(sig, intf.getMethod(method.getName(), method.getParameterTypes()));
                    }
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("target should implement all of the interfaces provided", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke(Request request) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getTargetClassLoader());
        try {
            Object result = this.invoke(request.methodSignature, request.args);
            Response response = new Response(request.requestId, result, null);
            return response;
        }
        catch (Throwable e) {
            Response response = new Response(request.requestId, null, e);
            return response;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private Object invoke(String signature, Object[] args) throws Throwable {
        Method method = this.methods.get(signature);
        if (method == null) {
            throw new UnmarshalException("The remote object does contain the method: " + signature);
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getTargetClassLoader());
        try {
            Object object = method.invoke(this.target, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw new UnmarshalException("Could not invoke method: " + signature, e);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.toString(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

