/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.usecase.elements.system;

import com.modeliosoft.modelio.diagram.editor.usecase.elements.system.GmSystemFreeZone;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.system.TranslateChildrenCommand;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

class SystemResizeCommand
extends Command {
    private GraphicalEditPart freeZoneEditPart;
    private GraphicalEditPart child;
    private ChangeBoundsRequest request;

    SystemResizeCommand(GraphicalEditPart freeZoneEditPart, GraphicalEditPart child, ChangeBoundsRequest request) {
        this.freeZoneEditPart = freeZoneEditPart;
        this.child = child;
        this.request = request;
    }

    public void execute() {
        Rectangle newRect = this.freeZoneEditPart.getFigure().getBounds().getCopy();
        Rectangle orig = newRect.getCopy();
        Rectangle useCaseBounds = this.child.getFigure().getBounds();
        newRect.union(this.request.getTransformedRectangle(useCaseBounds));
        Point moveDelta = newRect.getLocation().getTranslated(orig.getLocation().getNegated());
        Dimension sizeDelta = newRect.getSize().getShrinked(orig.getSize());
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setSizeDelta(sizeDelta);
        req.setMoveDelta(moveDelta);
        req.setEditParts(this.freeZoneEditPart.getParent());
        Command resizeParentCommand = this.freeZoneEditPart.getParent().getCommand((Request)req);
        if (resizeParentCommand != null && resizeParentCommand.canExecute()) {
            TranslateChildrenCommand command = new TranslateChildrenCommand((EditPart)this.freeZoneEditPart, moveDelta.getNegated());
            command.execute();
            resizeParentCommand.execute();
        }
    }

    public boolean canExecute() {
        return AuthHelper.canModifyDiagram((GmAbstractDiagram)((GmSystemFreeZone)this.freeZoneEditPart.getModel()).getDiagram());
    }
}

