/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.usecase.elements.usecase;

import com.modeliosoft.modelio.diagram.elements.core.figures.EllipseFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.ToolbarLayoutWithGrab;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.TLBRBorder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.graphics.Color;

public class UseCaseFigure
extends EllipseFigure {
    public UseCaseFigure() {
        ToolbarLayoutWithGrab layout = new ToolbarLayoutWithGrab();
        layout.setHorizontal(false);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        this.updateChildrenSeparationLine();
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.updateChildrenSeparationLine();
    }

    public void setLineColor(Color lineColor) {
        super.setLineColor(lineColor);
        this.updateChildrenSeparationLine();
    }

    public void setLineWidth(int lineWidth) {
        super.setLineWidth(lineWidth);
    }

    private void updateChildrenSeparationLine() {
        List children = this.getChildren();
        ArrayList<IFigure> withBorder = new ArrayList<IFigure>(children.size());
        ArrayList<IFigure> withNoBorder = new ArrayList<IFigure>(children.size());
        for (Object o : children) {
            IFigure child = (IFigure)o;
            if (child.isVisible()) {
                withBorder.add(child);
                continue;
            }
            withNoBorder.add(child);
        }
        if (!withBorder.isEmpty()) {
            withNoBorder.add((IFigure)withBorder.remove(withBorder.size() - 1));
        }
        TLBRBorder newBorder = new TLBRBorder(this.getLineColor(), this.getLineWidth(), false, false, true, false);
        for (IFigure f : withBorder) {
            f.setBorder((Border)newBorder);
        }
        for (IFigure f : withNoBorder) {
            f.setBorder(null);
        }
    }
}

