/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.system.GmSystem;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecase.GmUseCase;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram.GmUseCaseDiagram;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram.GmUseCaseDiagramStyleKeys;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram.UseCaseDiagramFigure;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram.UseCaseDiagramLayoutEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.LinkedNodeFinishCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.model.GmAbstractObject;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.CreateLinkIntermediateEditPolicy;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class UseCaseDiagramEditPart
extends AbstractDiagramEditPart {
    protected IFigure createFigure() {
        UseCaseDiagramFigure diagramFigure = new UseCaseDiagramFigure();
        IStyle style = ((GmAbstractObject)this.getModel()).getStyle();
        this.refreshFromStyle((IFigure)diagramFigure, style);
        return diagramFigure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new UseCaseDiagramLayoutEditPolicy());
        this.installEditPolicy((Object)"Linked node end", (EditPolicy)new LinkedNodeFinishCreationEditPolicy());
        this.installEditPolicy((Object)"add bendpoint to future connection", (EditPolicy)new CreateLinkIntermediateEditPolicy());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Style")) {
            this.refreshUseCaseOwnership();
        }
        super.propertyChange(evt);
    }

    private void refreshUseCaseOwnership() {
        GmSystem model = ((GmUseCaseDiagram)this.getModel()).getSystem();
        boolean isSystemVisible = (Boolean)model.getStyle().getProperty(GmUseCaseDiagramStyleKeys.SHOW_SYSTEM);
        if (!isSystemVisible) {
            for (GmNodeModel child : model.getBody().getChildren()) {
                GraphicalEditPart ep = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(child);
                if (ep == null) continue;
                Rectangle ucBounds = ep.getFigure().getBounds().getCopy();
                ep.getFigure().translateToAbsolute((Translatable)ucBounds);
                this.getFigure().translateToRelative((Translatable)ucBounds);
                child.setLayoutData((Object)ucBounds);
            }
            for (GmNodeModel child : model.getBody().getChildren()) {
                model.getBody().removeChild(child);
                model.getDiagram().addChild(child);
            }
        } else {
            HashMap<GmUseCase, Rectangle> layoutData = new HashMap<GmUseCase, Rectangle>();
            for (GmNodeModel child : model.getDiagram().getChildren()) {
                GmUseCase useCaseNode;
                IUseCase theUseCase;
                if (!(child instanceof GmUseCase) || (theUseCase = (useCaseNode = (GmUseCase)child).getRepresentedIElement()) == null || !this.isInSystem(model, (IElement)theUseCase)) continue;
                GraphicalEditPart uCEp = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(useCaseNode);
                Rectangle ucBounds = null;
                if (uCEp != null) {
                    ucBounds = uCEp.getFigure().getBounds().getCopy();
                    if (model.getLayoutData() == null) {
                        Rectangle systemBounds = ucBounds.getCopy();
                        systemBounds.setSize(-1, -1);
                        model.setLayoutData((Object)systemBounds);
                    }
                    uCEp.getFigure().translateToAbsolute((Translatable)ucBounds);
                    layoutData.put(useCaseNode, ucBounds);
                }
                model.getDiagram().removeChild(child);
                model.getBody().addChild(child);
            }
            this.getFigure().validate();
            for (GmNodeModel child : model.getBody().getChildren()) {
                GmUseCase useCaseGm = (GmUseCase)child;
                GraphicalEditPart useCaseEp = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(useCaseGm);
                GraphicalEditPart systemEp = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(model.getBody());
                Rectangle ucAbsBounds = (Rectangle)layoutData.get(useCaseGm);
                if (systemEp == null || ucAbsBounds == null) continue;
                Rectangle ucCurrentBounds = useCaseEp.getFigure().getBounds().getCopy();
                useCaseEp.getFigure().translateToAbsolute((Translatable)ucCurrentBounds);
                ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
                req.setEditParts((EditPart)useCaseEp);
                req.setMoveDelta(ucAbsBounds.getLocation().getTranslated(ucCurrentBounds.getLocation().getNegated()));
                req.setSizeDelta(ucAbsBounds.getSize().getShrinked(ucCurrentBounds.getSize()));
                Command command = useCaseEp.getCommand((Request)req);
                if (command == null || !command.canExecute()) continue;
                command.execute();
                this.getFigure().validate();
            }
        }
    }

    private boolean isInSystem(GmSystem model, IElement theUseCase) {
        return theUseCase.getCompositionOwner().equals((Object)model.getRepresentedIElement());
    }
}

