/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram;

import com.modeliosoft.modelio.api.model.diagrams.IUseCaseDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.system.GmSystem;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecase.GmUseCase;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram.GmUseCaseDiagram;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram.GmUseCaseDiagramStyleKeys;
import com.modeliosoft.modelio.diagram.editor.usecase.elements.usecasediagram.UseCaseDiagramLayoutEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.policies.DiagramEditLayoutPolicy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class UseCaseDiagramLayoutEditPolicy
extends DiagramEditLayoutPolicy {
    private static final Dimension USE_CASE_DEFAULT_SIZE = new Dimension(200, 75);

    protected Command getCreateCommand(CreateRequest request) {
        ModelioCreationContext ctx = (ModelioCreationContext)request.getNewObject();
        if ("UseCase".equals(ctx.getMetaclass())) {
            boolean systemShouldBeUsed;
            GmUseCaseDiagram diagramGm = (GmUseCaseDiagram)this.getHost().getModel();
            IModelElement diagramContext = ((IUseCaseDiagram)diagramGm.getRepresentedIElement()).getOrigin();
            IElement elementToUnmask = ctx.getElementToUnmask();
            boolean bl = systemShouldBeUsed = diagramContext != null && diagramGm.getStyle().getBoolean(GmUseCaseDiagramStyleKeys.SHOW_SYSTEM);
            if (systemShouldBeUsed && (elementToUnmask == null || this.isInSystem((IElement)diagramContext, elementToUnmask))) {
                GmSystem systemGm = diagramGm.getSystem();
                if (systemGm.getLayoutData() == null || !systemGm.isVisible()) {
                    CompoundCommand command = new CompoundCommand();
                    command.add((Command)new InitializeSystemBoundariesCommand(systemGm, (Object)((Rectangle)this.getConstraintFor(request)).setSize(-1, -1)));
                    Point locationSave = request.getLocation();
                    request.setLocation(new Point(0, 0));
                    command.add(super.getCreateCommand(request));
                    request.setLocation(locationSave);
                    return command.unwrap();
                }
                GraphicalEditPart systemEditPart = (GraphicalEditPart)this.getHost().getViewer().getEditPartRegistry().get(systemGm);
                GraphicalEditPart systemBodyEditPart = (GraphicalEditPart)this.getHost().getViewer().getEditPartRegistry().get(systemGm.getBody());
                IFigure systemBodyFigure = systemBodyEditPart.getFigure();
                Rectangle bodyBoundsOrig = systemBodyFigure.getBounds().getCopy();
                systemBodyFigure.translateToAbsolute((Translatable)bodyBoundsOrig);
                Rectangle bodyBoundsResized = bodyBoundsOrig.getCopy();
                bodyBoundsResized.union(request.getLocation());
                if (request.getSize() != null) {
                    bodyBoundsResized.union(request.getLocation().getTranslated(request.getSize()));
                } else {
                    bodyBoundsResized.union(request.getLocation().getTranslated(USE_CASE_DEFAULT_SIZE));
                }
                Point moveDelta = bodyBoundsResized.getLocation().getTranslated(bodyBoundsOrig.getLocation().getNegated());
                Dimension sizeDelta = bodyBoundsResized.getSize().getShrinked(bodyBoundsOrig.getSize());
                ChangeBoundsRequest sizeRequest = new ChangeBoundsRequest((Object)"resize");
                sizeRequest.setEditParts((EditPart)systemEditPart);
                sizeRequest.setMoveDelta(moveDelta);
                sizeRequest.setSizeDelta(sizeDelta);
                CompoundCommand command = new CompoundCommand();
                command.add(systemEditPart.getCommand((Request)sizeRequest));
                command.add(systemBodyEditPart.getTargetEditPart((Request)request).getCommand((Request)request));
                return command.unwrap();
            }
        }
        return super.getCreateCommand(request);
    }

    private boolean isInSystem(IElement systemElement, IElement theUseCase) {
        return theUseCase.isValid() && theUseCase.getCompositionOwner().equals((Object)systemElement);
    }

    protected Command createAddCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        Object childModel = child.getModel();
        if (childModel instanceof GmUseCase) {
            boolean systemShouldBeUsed;
            GmUseCase useCaseGm = (GmUseCase)childModel;
            IElement useCaseElement = useCaseGm.getRelatedIElement();
            GmUseCaseDiagram diagramGm = (GmUseCaseDiagram)this.getHost().getModel();
            IModelElement diagramContextElement = ((IUseCaseDiagram)diagramGm.getRepresentedIElement()).getOrigin();
            boolean bl = systemShouldBeUsed = diagramContextElement != null && diagramGm.getStyle().getBoolean(GmUseCaseDiagramStyleKeys.SHOW_SYSTEM);
            if (useCaseElement != null && systemShouldBeUsed && this.isInSystem((IElement)diagramContextElement, useCaseElement)) {
                GmSystem systemGm = diagramGm.getSystem();
                if (systemGm.getLayoutData() == null || !systemGm.isVisible()) {
                    CompoundCommand command = new CompoundCommand();
                    Rectangle systemBounds = ((Rectangle)constraint).getCopy();
                    systemBounds.setSize(-1, -1);
                    command.add((Command)new InitializeSystemBoundariesCommand(systemGm, (Object)systemBounds));
                    Point locationSave = request.getLocation();
                    request.setLocation(new Point(0, 0));
                    command.add(super.createAddCommand(request, child, constraint));
                    request.setLocation(locationSave);
                    return command.unwrap();
                }
                ChangeBoundsRequest moveRequest = new ChangeBoundsRequest((Object)"move children");
                moveRequest.setEditParts(child);
                moveRequest.setMoveDelta(request.getMoveDelta());
                moveRequest.setResizeDirection(request.getResizeDirection());
                GraphicalEditPart systemBodyEditPart = (GraphicalEditPart)this.getHost().getViewer().getEditPartRegistry().get(systemGm.getBody());
                return systemBodyEditPart.getCommand((Request)moveRequest);
            }
        }
        return super.createAddCommand(request, child, constraint);
    }
}

