/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.dnd;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.workbench.PasteElementObject;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.core.workbench.TransferItem;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.part.IDropActionDelegate;

public class NoteDropAdapter
implements IDropActionDelegate {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(Object source, Object target) {
        if (!(target instanceof IAdaptable)) return false;
        PasteElementTransfer transfer = PasteElementTransfer.getInstance();
        IAdaptable targetAdapter = (IAdaptable)target;
        IElement targetElement = (IElement)targetAdapter.getAdapter(IElement.class);
        PasteElementObject pasteObject = transfer.fromByteArray((byte[])source);
        List items = pasteObject.getTransferedItems();
        List pastedStereotypeItems = this.getStereotypesItemsToCopy(items);
        List pastedElements = this.getElementsToCopy(items);
        if (pasteObject.getPasteType() == PasteElementObject.PasteType.COPY) {
            IModelingSession modelingSession = Edition.getInstance().getSession();
            ITransactionManager transactionManager = modelingSession.getTransactionManager();
            ITransaction transaction = transactionManager.createTransaction("Copy");
            try {
                try {
                    ModelServices.copyTo((Collection)new ObList((Collection)pastedElements), (IElement)targetElement);
                    if (targetElement instanceof IModelElement) {
                        IModelElement selectedModelElement = (IModelElement)targetElement;
                        for (TransferItem item : pastedStereotypeItems) {
                            IStereotype stereotype = (IStereotype)item.getTransferedElement();
                            if (selectedModelElement.isStereotyped(stereotype.getName())) continue;
                            selectedModelElement.addExtension(stereotype);
                        }
                    }
                    transactionManager.commit(transaction);
                    transaction = null;
                    return true;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    if (transaction == null) return true;
                    transactionManager.rollback(transaction);
                    return true;
                }
                catch (Exception e) {
                    Edition.LOG.error((Throwable)e);
                    if (transaction == null) return true;
                    transactionManager.rollback(transaction);
                    return true;
                }
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        if (pasteObject.getPasteType() != PasteElementObject.PasteType.CUT) return false;
        for (IElement element : pastedElements) {
            if (!element.equals((Object)targetElement) && !this.isParentOf(element, targetElement)) continue;
            return false;
        }
        IModelingSession modelingSession = Edition.getInstance().getSession();
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Cut");
        try {
            try {
                ModelServices.moveTo((Collection)new ObList((Collection)pastedElements), (IElement)targetElement);
                if (targetElement instanceof IModelElement) {
                    IModelElement selectedModelElement = (IModelElement)targetElement;
                    for (TransferItem item : pastedStereotypeItems) {
                        IStereotype stereotype = (IStereotype)item.getTransferedElement();
                        IModelElement oldParent = (IModelElement)item.getOldParent();
                        oldParent.removeExtension(stereotype);
                        if (selectedModelElement.isStereotyped(stereotype.getName())) continue;
                        selectedModelElement.addExtension(stereotype);
                    }
                }
                transactionManager.commit(transaction);
                transaction = null;
                return true;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return true;
                transactionManager.rollback(transaction);
                return true;
            }
            catch (Exception e) {
                Edition.LOG.error((Throwable)e);
                if (transaction == null) return true;
                transactionManager.rollback(transaction);
                return true;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    private boolean isParentOf(IElement parentCandidate, IElement element) {
        IElement parent = element.getCompositionOwner();
        if (parent == null) {
            return false;
        }
        if (parentCandidate.equals((Object)parent)) {
            return true;
        }
        return this.isParentOf(parentCandidate, parent);
    }

    private List<TransferItem> getStereotypesItemsToCopy(List<TransferItem> items) {
        ArrayList<TransferItem> stereotypeItemsToCopy = new ArrayList<TransferItem>();
        for (TransferItem item : items) {
            if (!(item.getTransferedElement() instanceof IStereotype)) continue;
            stereotypeItemsToCopy.add(item);
        }
        return stereotypeItemsToCopy;
    }

    private List<IElement> getElementsToCopy(List<TransferItem> items) {
        ArrayList<IElement> elementsToCopy = new ArrayList<IElement>();
        for (TransferItem item : items) {
            IElement transferedElement = item.getTransferedElement();
            if (transferedElement instanceof IStereotype) continue;
            elementsToCopy.add(transferedElement);
        }
        return elementsToCopy;
    }
}

