/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.handlers;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.edition.annotations.view.ModelPropertyView;
import com.modeliosoft.modelio.edition.plugin.Edition;
import com.modeliosoft.modelio.mda.services.addStereotypeService.AddStereotypeService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AddStereotypeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IModelingSession session = Edition.getInstance().getSession();
        ModelPropertyView view = this.getAnnotationsView();
        if (view == null) {
            return null;
        }
        IElement typedElement = view.getCurrentElement();
        if (!(typedElement instanceof IModelElement)) {
            return null;
        }
        IModule selectedModule = null;
        IModelElement typingElement = view.getCurrentTypeItem();
        if (typingElement instanceof IModule) {
            selectedModule = (IModule)typingElement;
        } else if (typingElement instanceof IStereotype) {
            selectedModule = session.getModel().getMetamodelExtensions().getModule((IStereotype)typingElement);
        }
        AddStereotypeService addStereotypeService = new AddStereotypeService();
        IStereotype newStereotype = addStereotypeService.addStereotype(session, (IModelElement)typedElement, selectedModule);
        if (newStereotype != null) {
            this.selectStereotype(newStereotype);
        }
        return null;
    }

    public boolean isEnabled() {
        ModelPropertyView view = this.getModelPropertyView();
        if (view == null) {
            return false;
        }
        IElement typedElement = view.getCurrentElement();
        if (typedElement == null) {
            return false;
        }
        return typedElement instanceof IModelElement && typedElement.getElementStatus().isModifiable();
    }

    public boolean isHandled() {
        return true;
    }

    private ModelPropertyView getAnnotationsView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] references = page.getViewReferences();
        int i = 0;
        while (i < references.length) {
            if (references[i].getId().equals("com.modeliosoft.modelio.edition.ModelPropertyViewID")) {
                return (ModelPropertyView)references[i].getView(false);
            }
            ++i;
        }
        return null;
    }

    private void selectStereotype(IStereotype stereotype) {
        ModelPropertyView view = this.getModelPropertyView();
        if (view != null) {
            view.setCurrentElement(view.getCurrentElement());
            view.setCurrentTypeItem((Object)stereotype);
        }
    }

    private ModelPropertyView getModelPropertyView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (ModelPropertyView)page.findViewReference("com.modeliosoft.modelio.edition.ModelPropertyViewID").getView(false);
    }
}

