/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.workbench.PasteElementObject;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.core.workbench.TransferItem;
import com.modeliosoft.modelio.edition.annotations.view.ModelPropertyView;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CutAnnotationHandler
extends AbstractHandler {
    private Clipboard clipboard = new Clipboard(Display.getCurrent());

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        super.dispose();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ModelPropertyView view = (ModelPropertyView)HandlerUtil.getActivePart((ExecutionEvent)event);
        Control control = view.getFocusControl();
        if (control instanceof Text) {
            ((Text)control).cut();
        } else {
            List selectedElements = view.getSelectedTypeItems();
            PasteElementObject toCopy = new PasteElementObject(PasteElementObject.PasteType.CUT);
            for (IElement element : selectedElements) {
                if (!(element instanceof IStereotype)) continue;
                toCopy.addTransferedItems(new TransferItem(element, view.getCurrentElement()));
            }
            this.clipboard.setContents(new Object[]{toCopy}, new Transfer[]{PasteElementTransfer.getInstance()});
        }
        return null;
    }

    public boolean isEnabled() {
        ModelPropertyView view = this.getModelPropertyView();
        if (view == null) {
            return false;
        }
        Control control = view.getFocusControl();
        if (control instanceof Text) {
            return view.getCurrentElement().getElementStatus().isModifiable();
        }
        if (!view.getCurrentElement().getElementStatus().isModifiable()) {
            return false;
        }
        for (IModelElement me : view.getSelectedTypeItems()) {
            if (me instanceof IStereotype) continue;
            return false;
        }
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    private ModelPropertyView getModelPropertyView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (ModelPropertyView)page.findViewReference("com.modeliosoft.modelio.edition.ModelPropertyViewID").getView(false);
    }
}

