/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.annotations.view.ModelPropertyView;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class MoveStereotypeUp
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ModelPropertyView view = (ModelPropertyView)HandlerUtil.getActivePart((ExecutionEvent)event);
        IElement element = view.getCurrentElement();
        List typeItems = view.getSelectedTypeItems();
        if (element instanceof IModelElement) {
            this.moveStereotypesUp((IModelElement)element, typeItems);
            view.refreshView();
        }
        return null;
    }

    public boolean isEnabled() {
        ModelPropertyView view = this.getModelPropertyView();
        if (view == null) {
            return false;
        }
        IElement element = view.getCurrentElement();
        if (element == null) {
            return false;
        }
        if (!(element instanceof IModelElement)) {
            return false;
        }
        if (!element.getElementStatus().isModifiable()) {
            return false;
        }
        List typeItems = view.getSelectedTypeItems();
        for (IModelElement me : typeItems) {
            if (me instanceof IStereotype) continue;
            return false;
        }
        return this.canMoveUp((IModelElement)element, view.getSelectedTypeItems());
    }

    public boolean isHandled() {
        return true;
    }

    private ModelPropertyView getModelPropertyView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (ModelPropertyView)page.findViewReference("com.modeliosoft.modelio.edition.ModelPropertyViewID").getView(false);
    }

    private boolean canMoveUp(IModelElement element, List<IModelElement> stereotypesToMove) {
        ObList stereotypes = element.getExtension();
        if (stereotypes.size() > 0) {
            return !stereotypesToMove.contains(stereotypes.get(0));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveStereotypesUp(IModelElement owner, List<IModelElement> stereotypesToMove) {
        if (owner == null || stereotypesToMove == null || stereotypesToMove.isEmpty()) {
            return;
        }
        int nMoves = 0;
        ArrayList<IElement> listToReorder = new ArrayList<IElement>((Collection<IElement>)owner.getExtension());
        for (IElement iElement : stereotypesToMove) {
            int index = listToReorder.indexOf(iElement);
            if (index <= 0) continue;
            listToReorder.remove(index);
            listToReorder.add(index - 1, iElement);
            ++nMoves;
        }
        if (nMoves <= 0) return;
        IModelingSession iModelingSession = Edition.getInstance().getSession();
        ITransactionManager transactionManager = iModelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("MoveUp");
        try {
            try {
                ModelServices.reorderDep((IElement)owner, (String)"Extension", (List)new ObList(listToReorder.toArray(new IElement[listToReorder.size()])));
                transactionManager.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
            catch (RuntimeException e) {
                Edition.LOG.error((Throwable)e);
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }
}

