/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.workbench.PasteElementObject;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.core.workbench.TransferItem;
import com.modeliosoft.modelio.edition.annotations.view.ModelPropertyView;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PasteAnnotationHandler
extends AbstractHandler {
    private Clipboard clipboard = new Clipboard(Display.getCurrent());

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        super.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IModelingSession modelingSession = Edition.getInstance().getSession();
        ModelPropertyView view = this.getModelPropertyView();
        Control control = view.getFocusControl();
        if (control instanceof Text) {
            ((Text)control).paste();
            return null;
        }
        IElement selectedElement = view.getCurrentElement();
        if (selectedElement == null) {
            return null;
        }
        if (!(selectedElement instanceof IModelElement)) {
            return null;
        }
        PasteElementObject pastedObject = (PasteElementObject)this.clipboard.getContents((Transfer)PasteElementTransfer.getInstance());
        if (pastedObject == null) {
            return null;
        }
        List items = pastedObject.getTransferedItems();
        List pastedStereotypeItems = this.getStereotypesItemsToCopy(items);
        List pastedElements = this.getElementsToCopy(items);
        if (pastedObject.getPasteType() == PasteElementObject.PasteType.COPY) {
            ITransactionManager transactionManager = modelingSession.getTransactionManager();
            ITransaction transaction = transactionManager.createTransaction("Copy");
            try {
                try {
                    if (pastedElements.size() > 0) {
                        ModelServices.copyTo((Collection)new ObList((Collection)pastedElements), (IElement)selectedElement);
                    }
                    IModelElement selectedModelElement = (IModelElement)selectedElement;
                    for (TransferItem item : pastedStereotypeItems) {
                        IStereotype stereotype = (IStereotype)item.getTransferedElement();
                        if (selectedModelElement.isStereotyped(stereotype.getName())) continue;
                        selectedModelElement.addExtension(stereotype);
                    }
                    transactionManager.commit(transaction);
                    transaction = null;
                    return null;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    if (transaction == null) return null;
                    transactionManager.rollback(transaction);
                    transaction = null;
                    return null;
                }
                catch (Exception e) {
                    this.reportException(e);
                    if (transaction == null) return null;
                    transactionManager.rollback(transaction);
                    transaction = null;
                    return null;
                }
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                    transaction = null;
                }
            }
        }
        if (pastedObject.getPasteType() != PasteElementObject.PasteType.CUT) return null;
        for (IElement element : pastedElements) {
            if (!element.equals((Object)selectedElement) && !this.isParentOf(element, selectedElement)) continue;
            return null;
        }
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Cut");
        try {
            try {
                if (pastedElements.size() > 0) {
                    ModelServices.moveTo((Collection)new ObList((Collection)pastedElements), (IElement)selectedElement);
                }
                IModelElement selectedModelElement = (IModelElement)selectedElement;
                for (TransferItem item : pastedStereotypeItems) {
                    IStereotype stereotype = (IStereotype)item.getTransferedElement();
                    IModelElement oldParent = (IModelElement)item.getOldParent();
                    oldParent.removeExtension(stereotype);
                    if (selectedModelElement.isStereotyped(stereotype.getName())) continue;
                    selectedModelElement.addExtension(stereotype);
                }
                transactionManager.commit(transaction);
                transaction = null;
                pastedObject.setPasteType(PasteElementObject.PasteType.COPY);
                this.clipboard.setContents(new Object[]{pastedObject}, new Transfer[]{PasteElementTransfer.getInstance()});
                return null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                transaction = null;
                return null;
            }
            catch (Exception e) {
                this.reportException(e);
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                transaction = null;
                return null;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
                transaction = null;
            }
        }
    }

    public boolean isEnabled() {
        ModelPropertyView view = this.getModelPropertyView();
        if (view != null && view.getCurrentElement() != null) {
            IElement modelElement = view.getCurrentElement();
            return modelElement.getElementStatus().isModifiable();
        }
        return false;
    }

    public boolean isHandled() {
        return true;
    }

    private boolean isParentOf(IElement parentCandidate, IElement element) {
        IElement parent = element.getCompositionOwner();
        if (parent == null) {
            return false;
        }
        if (parentCandidate.equals((Object)parent)) {
            return true;
        }
        return this.isParentOf(parentCandidate, parent);
    }

    private List<TransferItem> getStereotypesItemsToCopy(List<TransferItem> items) {
        ArrayList<TransferItem> stereotypeItemsToCopy = new ArrayList<TransferItem>();
        for (TransferItem item : items) {
            if (!(item.getTransferedElement() instanceof IStereotype)) continue;
            stereotypeItemsToCopy.add(item);
        }
        return stereotypeItemsToCopy;
    }

    private List<IElement> getElementsToCopy(List<TransferItem> items) {
        ArrayList<IElement> elementsToCopy = new ArrayList<IElement>();
        for (TransferItem item : items) {
            IElement transferedElement = item.getTransferedElement();
            if (transferedElement instanceof IStereotype) continue;
            elementsToCopy.add(transferedElement);
        }
        return elementsToCopy;
    }

    void reportException(Exception e) {
        String title = Edition.I18N.getMessage("CannotPasteClipboard", new String[0]);
        MessageDialog.openError(null, (String)title, (String)e.getLocalizedMessage());
        if (!(e instanceof InvalidModelManipulationException)) {
            LOG.error((String)"org.modelio.edition", (Throwable)e);
        }
    }

    private ModelPropertyView getModelPropertyView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (ModelPropertyView)page.findViewReference("com.modeliosoft.modelio.edition.ModelPropertyViewID").getView(false);
    }
}

