/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.annotations.view.ModelPropertyView;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveAnnotationHandler
extends AbstractHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ModelPropertyView modelPropertyView = (ModelPropertyView)HandlerUtil.getActivePart((ExecutionEvent)event);
        if (modelPropertyView == null) return null;
        IElement typedElement = modelPropertyView.getCurrentElement();
        if (!(typedElement instanceof IModelElement)) {
            return null;
        }
        List typingItems = modelPropertyView.getSelectedTypeItems();
        ITransactionManager transactionManager = Edition.getInstance().getSession().getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Annotation deletion");
        try {
            try {
                for (IModelElement typeItem : typingItems) {
                    if (!(typeItem instanceof IStereotype)) continue;
                    ((IModelElement)typedElement).removeExtension((IStereotype)typeItem);
                }
                transactionManager.commit(transaction);
                transaction = null;
                return null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                return null;
            }
            catch (Exception e) {
                LOG.error((String)"org.modelio.edition", (Throwable)e);
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                return null;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    public boolean isEnabled() {
        ModelPropertyView view = this.getModelPropertyView();
        if (view == null) {
            return false;
        }
        IElement element = view.getCurrentElement();
        if (element == null) {
            return false;
        }
        if (!(element instanceof IModelElement)) {
            return false;
        }
        if (!element.getElementStatus().isModifiable()) {
            return false;
        }
        List typeItems = view.getSelectedTypeItems();
        for (IModelElement me : typeItems) {
            if (me instanceof IStereotype && !((IStereotype)me).isHidden()) continue;
            return false;
        }
        return typeItems.size() > 0;
    }

    public boolean isHandled() {
        return true;
    }

    private ModelPropertyView getModelPropertyView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (ModelPropertyView)page.findViewReference("com.modeliosoft.modelio.edition.ModelPropertyViewID").getView(false);
    }
}

