/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.INavigationListener;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.edition.annotations.view.ModelPropertyView;
import com.modeliosoft.modelio.edition.annotations.view.data.ContentPanel;
import com.modeliosoft.modelio.edition.annotations.view.tree.TreePanel;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.part.ViewPart;

public class ModelPropertyView
extends ViewPart
implements ISessionListener {
    public static final String VIEW_ID = "com.modeliosoft.modelio.edition.ModelPropertyViewID";
    private LayoutChangeListener layoutChangeListener = null;
    private ContentPanel contentPanel = null;
    private IElement currentElement;
    private SelectionListener selectionListener;
    private ModelChangeListener modelChangeListener;
    private NavigationListener navigationListener;
    private SelectionChangedListener treeSelectionListener;
    private TreePanel treePanel = null;
    protected boolean pinned;
    private IPickingProvider pickingProvider;
    private SashForm shform = null;
    Composite theViewParent = null;

    public void createPartControl(Composite parent) {
        this.theViewParent = parent;
        this.shform = new SashForm(parent, 256);
        this.shform.setLayout((Layout)new FillLayout());
        this.treePanel = new TreePanel(this.shform, 0, this);
        this.contentPanel = new ContentPanel(this.shform, 0, this);
        this.treePanel.setLayout((Layout)new FillLayout());
        this.contentPanel.setLayout((Layout)new FillLayout());
        this.shform.setWeights(new int[]{30, 70});
        this.layoutChangeListener = new LayoutChangeListener(this);
        this.enableAutoLayout();
        IContextService contextService = (IContextService)this.getViewSite().getService(IContextService.class);
        contextService.activateContext("com.modeliosoft.modelio.bindings.context.AnnotationViewID");
        this.setTitleToolTip(Edition.I18N.getString("NotesTabTooltip"));
        this.treeSelectionListener = new SelectionChangedListener(this);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.treeSelectionListener);
    }

    public void setHorizontalLayout() {
        this.shform.setOrientation(256);
        new Sash((Composite)this.shform, 2560);
    }

    public void setVerticalLayout() {
        this.shform.setOrientation(512);
        new Sash((Composite)this.shform, 2304);
    }

    public void enableAutoLayout() {
        this.theViewParent.addControlListener((ControlListener)this.layoutChangeListener);
    }

    public void disableAutoLayout() {
        this.theViewParent.removeControlListener((ControlListener)this.layoutChangeListener);
    }

    public void setFocus() {
        this.treePanel.setFocus();
    }

    TreeViewer getTreeViewer() {
        return this.treePanel.getTreeViewer();
    }

    public Control getFocusControl() {
        return this.theViewParent.getDisplay().getFocusControl();
    }

    TreePanel getTreePanel() {
        return this.treePanel;
    }

    public IElement getCurrentElement() {
        return this.currentElement;
    }

    public void setCurrentElement(IElement selectedElement) {
        if (selectedElement == null) {
            this.currentElement = null;
            this.treePanel.setInput(null, null);
            this.contentPanel.setInput(null, null);
            return;
        }
        this.currentElement = selectedElement;
        this.contentPanel.setInput(null, null);
        this.treePanel.setInput(this.currentElement, null);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.selectionListener = new SelectionListener(this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.selectionListener);
        O.getDefault().getSessionService().addSessionListener((ISessionListener)this);
        this.pickingProvider = new /* Unavailable Anonymous Inner Class!! */;
        O.getDefault().getPickingProviderService().addPickingProvider(this.pickingProvider);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.selectionListener);
        this.selectionListener = null;
        O.getDefault().getSessionService().removeSessionListener((ISessionListener)this);
        O.getDefault().getPickingProviderService().removePickingProvider(this.pickingProvider);
        this.pickingProvider = null;
        this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this.treeSelectionListener);
        this.treeSelectionListener = null;
        super.dispose();
    }

    private void updateToolbar() {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.getViewSite().getActionBars().getToolBarManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof CommandContributionItem) {
                CommandContributionItem commandItem = (CommandContributionItem)item;
                commandItem.update();
            }
            ++n2;
        }
    }

    public IModelElement getCurrentTypeItem() {
        return this.contentPanel.getCurrentInput();
    }

    public void setCurrentTypeItem(Object typeItem) {
        this.contentPanel.setInput(this.currentElement, typeItem);
        if (typeItem != null) {
            this.treePanel.setLastType(typeItem);
        }
        this.updateToolbar();
    }

    public void refreshView() {
        if (this.treePanel.getTreeViewer().getTree() == null || this.treePanel.getTreeViewer().getTree().isDisposed()) {
            return;
        }
        if (this.currentElement != null && this.currentElement.isValid()) {
            if (this.getCurrentTypeItem() != null && this.getCurrentTypeItem().isValid()) {
                this.treePanel.setInput(this.currentElement, (IElement)this.getCurrentTypeItem());
            } else {
                this.treePanel.setInput(this.currentElement, null);
            }
        } else {
            this.currentElement = null;
            this.treePanel.setInput(null, null);
        }
        this.updateToolbar();
    }

    public void sessionOpened(IModelingSession session) {
        this.navigationListener = new NavigationListener(this);
        O.getDefault().getNavigateService().addNavigationListener((INavigationListener)this.navigationListener);
        this.modelChangeListener = new ModelChangeListener(this);
        session.getModel().addModelListener((IModelChangeListener)this.modelChangeListener);
        session.getModel().addStatusListener((IStatusChangeListener)this.modelChangeListener);
    }

    public void sessionClosed(IModelingSession session) {
        this.setCurrentElement(null);
        session.getModel().removeModelListener((IModelChangeListener)this.modelChangeListener);
        session.getModel().removeStatusListener((IStatusChangeListener)this.modelChangeListener);
        this.modelChangeListener = null;
        O.getDefault().getNavigateService().removeNavigationListener((INavigationListener)this.navigationListener);
        this.navigationListener = null;
    }

    public List<IModelElement> getSelectedTypeItems() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    public boolean isPinned() {
        return this.pinned;
    }
}

