/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.bpmn;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.ObBpmnProcessTypeEnum;
import com.modeliosoft.modelio.api.model.bpmn.ObOptionalBooleanEnum;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;

public class BpmnProcessPropertyModel
implements IPropertyModel {
    private static final String[] properties = new String[]{"Process", "Name", "ProcessType", "Closed", "Executable"};
    private IBpmnProcess theBpmnProcess;

    public BpmnProcessPropertyModel(IBpmnProcess theBpmnProcess) {
        this.theBpmnProcess = theBpmnProcess;
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return properties.length;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return properties[row];
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return "Value";
                    }
                    case 1: {
                        return this.theBpmnProcess.getName();
                    }
                    case 2: {
                        return this.theBpmnProcess.getProcessType();
                    }
                    case 3: {
                        return this.theBpmnProcess.isClosed() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 4: {
                        return this.theBpmnProcess.getExecutable();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return new StringType(false);
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return new StringType(false);
                    }
                    case 1: {
                        return new StringType(true);
                    }
                    case 2: {
                        return new EnumType(false, ObBpmnProcessTypeEnum.class);
                    }
                    case 3: {
                        return new BooleanType();
                    }
                    case 4: {
                        return new EnumType(false, ObOptionalBooleanEnum.class);
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        block0 : switch (col) {
            case 0: {
                return;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.theBpmnProcess.setName((String)value);
                        break block0;
                    }
                    case 2: {
                        this.theBpmnProcess.setProcessType((ObBpmnProcessTypeEnum)value);
                        break block0;
                    }
                    case 3: {
                        this.theBpmnProcess.setClosed(((Boolean)value).booleanValue());
                        break block0;
                    }
                    case 4: {
                        this.theBpmnProcess.setExecutable((ObOptionalBooleanEnum)value);
                        break block0;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IElementStatus status = modelingSession.getElementStatus((IElement)this.theBpmnProcess);
        return status.isModifiable();
    }
}

