/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.bpmn;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnEventDefinition;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnStartEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.annotations.view.data.standard.model.bpmn.BpmnStartEventPropertyModel;
import com.modeliosoft.modelio.edition.plugin.Edition;

/*
 * Exception performing whole class analysis ignored.
 */
public class BpmnStartEventPropertyModel
implements IPropertyModel {
    private static final String[] properties = new String[]{"StartEvent", "Name", "Type", "ParallelMultiple", "Interrupting"};
    private IBpmnStartEvent theBpmnStartEvent;

    public BpmnStartEventPropertyModel(IBpmnStartEvent theBpmnStartEvent) {
        this.theBpmnStartEvent = theBpmnStartEvent;
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return properties.length;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return properties[row];
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return "Value";
                    }
                    case 1: {
                        return this.theBpmnStartEvent.getName();
                    }
                    case 2: {
                        return this.getType();
                    }
                    case 3: {
                        return this.theBpmnStartEvent.isParallelMultiple() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 4: {
                        return this.theBpmnStartEvent.isInterrupting() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return new StringType(false);
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return new StringType(false);
                    }
                    case 1: {
                        return new StringType(true);
                    }
                    case 2: {
                        return new EnumType(false, this.getEnumeration());
                    }
                    case 3: {
                        return new BooleanType();
                    }
                    case 4: {
                        return new BooleanType();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        block0 : switch (col) {
            case 0: {
                return;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.theBpmnStartEvent.setName((String)value);
                        break block0;
                    }
                    case 2: {
                        this.setType(value);
                        break block0;
                    }
                    case 3: {
                        this.theBpmnStartEvent.setParallelMultiple(((Boolean)value).booleanValue());
                        break block0;
                    }
                    case 4: {
                        this.theBpmnStartEvent.setInterrupting(((Boolean)value).booleanValue());
                        break block0;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IElementStatus status = modelingSession.getElementStatus((IElement)this.theBpmnStartEvent);
        return status.isModifiable();
    }

    private Object getType() {
        if (this.getEnumeration() == EventType.class) {
            ObList definition = this.theBpmnStartEvent.getEventDefinitions();
            if (definition.size() == 0) {
                return EventType.None;
            }
            if (definition.size() == 1) {
                return EventType.getType((IBpmnEventDefinition)((IBpmnEventDefinition)definition.get(0)));
            }
            return EventType.Multiple;
        }
        if (this.getEnumeration() == SubEventType.class) {
            ObList definition = this.theBpmnStartEvent.getEventDefinitions();
            if (definition.size() == 0) {
                return SubEventType.None;
            }
            if (definition.size() == 1) {
                return SubEventType.getType((IBpmnEventDefinition)((IBpmnEventDefinition)definition.get(0)));
            }
            return SubEventType.Multiple;
        }
        if (this.getEnumeration() == InterSubEventType.class) {
            ObList definition = this.theBpmnStartEvent.getEventDefinitions();
            if (definition.size() == 0) {
                return InterSubEventType.None;
            }
            if (definition.size() == 1) {
                return InterSubEventType.getType((IBpmnEventDefinition)((IBpmnEventDefinition)definition.get(0)));
            }
            return InterSubEventType.Multiple;
        }
        return null;
    }

    private Class getEnumeration() {
        if (this.theBpmnStartEvent.getCompositionOwner() instanceof IBpmnSubProcess) {
            if (this.theBpmnStartEvent.isInterrupting()) {
                return InterSubEventType.class;
            }
            return SubEventType.class;
        }
        return EventType.class;
    }

    private void setType(Object type) {
        if (this.getEnumeration() == EventType.class) {
            EventType event_type = (EventType)type;
            if (type == EventType.None) {
                this.deleteEventType();
            } else if (type == EventType.Multiple) {
                this.createMultipleEventType();
            } else {
                this.deleteEventType();
                this.createEventType(EventType.getMetaclass((EventType)event_type));
            }
        } else if (this.getEnumeration() == SubEventType.class) {
            SubEventType event_type = (SubEventType)type;
            if (type == SubEventType.None) {
                this.deleteEventType();
            } else if (type == SubEventType.Multiple) {
                this.createMultipleEventType();
            } else {
                this.deleteEventType();
                this.createEventType(SubEventType.getMetaclass((SubEventType)event_type));
            }
        } else if (this.getEnumeration() == InterSubEventType.class) {
            InterSubEventType event_type = (InterSubEventType)type;
            if (type == InterSubEventType.None) {
                this.deleteEventType();
            } else if (type == InterSubEventType.Multiple) {
                this.createMultipleEventType();
            } else {
                this.deleteEventType();
                this.createEventType(InterSubEventType.getMetaclass((InterSubEventType)event_type));
            }
        }
    }

    private void createMultipleEventType() {
        ObList definitions = this.theBpmnStartEvent.getEventDefinitions();
        if (definitions.size() == 0) {
            this.createEventType("BpmnMessageEventDefinition");
            this.createEventType("BpmnSignalEventDefinition");
        } else if (definitions.size() == 1) {
            this.createEventType("BpmnMessageEventDefinition");
        }
    }

    private void createEventType(String metaclass) {
        IModelingSession session = O.getDefault().getModelingSession();
        IBpmnEventDefinition event_definition = (IBpmnEventDefinition)session.getModelFactory().createElement(metaclass);
        DefaultNameFactory.setDefaultName((IModelElement)event_definition);
        event_definition.setDefined((IBpmnEvent)this.theBpmnStartEvent);
    }

    private void deleteEventType() {
        IModelingSession session = O.getDefault().getModelingSession();
        for (IBpmnEventDefinition definition : this.theBpmnStartEvent.getEventDefinitions()) {
            session.getModelFactory().deleteElement((IElement)definition);
        }
    }
}

