/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.bpmn;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLoopCharacteristics;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnMultiInstanceLoopCharacteristics;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnStandardLoopCharacteristics;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;

public enum LoopType {
    None,
    Standard,
    MultiInstanceSequential,
    MultiInstanceParallel;


    public static LoopType getType(IBpmnActivity activity) {
        IBpmnLoopCharacteristics definition = activity.getLoopCharacteristics();
        if (definition instanceof IBpmnStandardLoopCharacteristics) {
            return Standard;
        }
        if (definition instanceof IBpmnMultiInstanceLoopCharacteristics) {
            IBpmnMultiInstanceLoopCharacteristics multi = (IBpmnMultiInstanceLoopCharacteristics)definition;
            if (multi.isSequencial()) {
                return MultiInstanceSequential;
            }
            return MultiInstanceParallel;
        }
        return None;
    }

    public static void setType(Object type, IBpmnActivity activity) {
        IModelingSession session = O.getDefault().getModelingSession();
        IBpmnLoopCharacteristics ch = activity.getLoopCharacteristics();
        if (ch != null) {
            session.getModelFactory().deleteElement((IElement)ch);
        }
        if (type == Standard) {
            IBpmnStandardLoopCharacteristics event_definition = (IBpmnStandardLoopCharacteristics)session.getModelFactory().createElement("BpmnStandardLoopCharacteristics");
            event_definition.setOwnerActivity(activity);
        } else if (type == MultiInstanceParallel) {
            IBpmnMultiInstanceLoopCharacteristics event_definition = (IBpmnMultiInstanceLoopCharacteristics)session.getModelFactory().createElement("BpmnMultiInstanceLoopCharacteristics");
            event_definition.setOwnerActivity(activity);
            event_definition.setSequencial(false);
        } else if (type == MultiInstanceSequential) {
            IBpmnMultiInstanceLoopCharacteristics event_definition = (IBpmnMultiInstanceLoopCharacteristics)session.getModelFactory().createElement("BpmnMultiInstanceLoopCharacteristics");
            event_definition.setOwnerActivity(activity);
            event_definition.setSequencial(true);
        }
    }
}

