/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ObAggregationKindEnum;
import com.modeliosoft.modelio.api.model.uml.statik.ObKindOfAccessEnum;
import com.modeliosoft.modelio.api.model.uml.statik.ObVisibilityModeEnum;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IElementFilter;
import com.modeliosoft.modelio.core.ui.MetamodelLabels;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml.AssociationEnd2PropertyModel;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AssociationEnd2PropertyModel
implements IPropertyModel {
    private IAssociationEnd element;
    private static final String[] PROPERTIES = new String[]{"Association", "AssociationName", "Class", "Role", "Visibility", "MultiplicityMin", "MultiplicityMax", "AssociationType", "IsModifiable", "IsNavigable", "AccessMode", "IsAbstract", "IsClass", "IsOrdered", "IsUnique"};
    private StringType labelStringType = null;
    private StringType stringType = null;
    private BooleanType booleanType = null;
    private SingleElementType classifierType = null;
    private EnumType visibilityType = null;
    private EnumType kindOfAccessType = null;
    private EnumType kindOfAssociationType = null;
    private ListStringType cardinalityMinType = null;
    private ListStringType cardinalityMaxType = null;

    public AssociationEnd2PropertyModel(IAssociationEnd element) {
        this.element = element;
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.booleanType = new BooleanType();
        this.classifierType = new SingleElementType(false, IClassifier.class);
        this.classifierType.setElementFilter((IElementFilter)new ClassifierTypeFilter(this));
        this.visibilityType = new EnumType(false, ObVisibilityModeEnum.class);
        this.kindOfAccessType = new EnumType(false, ObKindOfAccessEnum.class);
        this.kindOfAssociationType = new EnumType(false, ObAggregationKindEnum.class);
        ArrayList<String> cardinalityMinValues = new ArrayList<String>();
        cardinalityMinValues.add("0");
        cardinalityMinValues.add("1");
        this.cardinalityMinType = new ListStringType(true, cardinalityMinValues);
        ArrayList<String> cardinalityMaxValues = new ArrayList<String>();
        cardinalityMaxValues.add("1");
        cardinalityMaxValues.add("*");
        this.cardinalityMaxType = new ListStringType(true, cardinalityMaxValues);
    }

    public Object getValueAt(int row, int col) {
        if (row == 1) {
            if (col == 0) {
                return PROPERTIES[row];
            }
            if (col == 1) {
                IAssociation association = this.element.getRelated();
                if (association == null) {
                    return MetamodelLabels.getString((String)"AssociationEnd.NoAssociation");
                }
                return association.getName();
            }
            return "";
        }
        switch (col) {
            case 0: {
                if (row == 0) {
                    return MessageFormat.format(MetamodelLabels.getString((String)"Title.Association"), this.element.getName());
                }
                return PROPERTIES[row];
            }
            case 1: {
                IAssociationEnd relatedEnd = this.getRelatedEnd(this.element);
                if (relatedEnd != null) {
                    return this.getPropertyValue(row, relatedEnd);
                }
                return null;
            }
            case 2: {
                return this.getPropertyValue(row, this.element);
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        switch (col) {
            case 0: {
                return;
            }
            case 1: {
                IAssociationEnd relatedEnd = this.getRelatedEnd(this.element);
                if (relatedEnd != null) {
                    this.setPropertyValue(row, relatedEnd, value);
                }
                return;
            }
            case 2: {
                this.setPropertyValue(row, this.element, value);
                return;
            }
        }
    }

    public int getColumnNumber() {
        return 3;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: 
            case 2: {
                switch (row) {
                    case 0: {
                        return this.labelStringType;
                    }
                    case 1: {
                        return this.stringType;
                    }
                    case 2: {
                        return this.classifierType;
                    }
                    case 3: {
                        return this.stringType;
                    }
                    case 4: {
                        return this.visibilityType;
                    }
                    case 5: {
                        return this.cardinalityMinType;
                    }
                    case 6: {
                        return this.cardinalityMaxType;
                    }
                    case 7: {
                        return this.kindOfAssociationType;
                    }
                    case 8: {
                        return this.booleanType;
                    }
                    case 9: {
                        return this.booleanType;
                    }
                    case 10: {
                        return this.kindOfAccessType;
                    }
                    case 11: {
                        return this.booleanType;
                    }
                    case 12: {
                        return this.booleanType;
                    }
                    case 13: {
                        return this.booleanType;
                    }
                    case 14: {
                        return this.booleanType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEditable(int row, int col) {
        IModelingSession modelingSession;
        IElementStatus status;
        if (col == 0) {
            return false;
        }
        if (row == 1) {
            if (col != 1) return false;
            IModelingSession modelingSession2 = Edition.getInstance().getSession();
            IAssociation theAssociation = this.element.getRelated();
            if (theAssociation == null) {
                return false;
            }
            IElementStatus status2 = modelingSession2.getElementStatus((IElement)theAssociation);
            if (status2.isModifiable()) return true;
            return false;
        }
        if (col == 1) {
            IAssociationEnd relatedEnd = this.getRelatedEnd(this.element);
            IModelingSession modelingSession3 = Edition.getInstance().getSession();
            IElementStatus status3 = modelingSession3.getElementStatus((IElement)relatedEnd);
            if (status3.isModifiable()) return true;
            return false;
        }
        if (col != 2 || (status = (modelingSession = Edition.getInstance().getSession()).getElementStatus((IElement)this.element)).isModifiable()) return true;
        return false;
    }

    private Object getPropertyValue(int row, IAssociationEnd associationEnd) {
        IAssociationEnd relatedEnd = this.getRelatedEnd(associationEnd);
        switch (row) {
            case 0: {
                if (relatedEnd == null) {
                    return "";
                }
                IClassifier type = relatedEnd.getOwner();
                if (type == null) {
                    return "";
                }
                if (associationEnd == this.element) {
                    return MessageFormat.format(MetamodelLabels.getString((String)"Title.to"), type.getName());
                }
                return MessageFormat.format(MetamodelLabels.getString((String)"Title.from"), type.getName());
            }
            case 1: {
                IAssociation association = this.element.getRelated();
                if (association == null) {
                    return MetamodelLabels.getString((String)"AssociationEnd.NoAssociation");
                }
                return association.getName();
            }
            case 2: {
                if (relatedEnd != null) {
                    IClassifier relatedClassifier = relatedEnd.getOwner();
                    return relatedClassifier;
                }
                return null;
            }
            case 3: {
                return associationEnd.getName();
            }
            case 4: {
                return associationEnd.getVisibility();
            }
            case 5: {
                return associationEnd.getMultiplicityMin();
            }
            case 6: {
                return associationEnd.getMultiplicityMax();
            }
            case 7: {
                return relatedEnd.getAggregation();
            }
            case 8: {
                return associationEnd.isChangeable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return associationEnd.isNavigable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return associationEnd.getChangeable();
            }
            case 11: {
                return associationEnd.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return associationEnd.isClass() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return associationEnd.isOrdered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return associationEnd.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private IAssociationEnd getRelatedEnd(IAssociationEnd associationEnd) {
        IAssociation association = associationEnd.getRelated();
        if (association != null) {
            ObList associationEndList = association.getConnection();
            IAssociationEnd end = null;
            int i = 0;
            while (i < associationEndList.size()) {
                end = (IAssociationEnd)associationEndList.get(i);
                if (end != null && !end.equals((Object)associationEnd)) {
                    return end;
                }
                ++i;
            }
        }
        return null;
    }

    private void setPropertyValue(int row, IAssociationEnd associationEnd, Object value) {
        IAssociationEnd relatedEnd = this.getRelatedEnd(associationEnd);
        switch (row) {
            case 0: {
                return;
            }
            case 1: {
                IAssociation theAssociation = this.element.getRelated();
                if (theAssociation == null) break;
                theAssociation.setName((String)value);
                break;
            }
            case 2: {
                if (relatedEnd == null) break;
                relatedEnd.setOwner((IClassifier)value);
                break;
            }
            case 3: {
                associationEnd.setName(String.valueOf(value));
                break;
            }
            case 4: {
                associationEnd.setVisibility((ObVisibilityModeEnum)value);
                break;
            }
            case 5: {
                associationEnd.setMultiplicityMin(String.valueOf(value));
                break;
            }
            case 6: {
                associationEnd.setMultiplicityMax(String.valueOf(value));
                break;
            }
            case 7: {
                relatedEnd.setAggregation((ObAggregationKindEnum)value);
                break;
            }
            case 8: {
                associationEnd.setChangeable(((Boolean)value).booleanValue());
                break;
            }
            case 9: {
                associationEnd.setNavigable(((Boolean)value).booleanValue());
                break;
            }
            case 10: {
                associationEnd.setChangeable((ObKindOfAccessEnum)value);
                break;
            }
            case 11: {
                associationEnd.setAbstract(((Boolean)value).booleanValue());
                break;
            }
            case 12: {
                associationEnd.setClass(((Boolean)value).booleanValue());
                break;
            }
            case 13: {
                associationEnd.setOrdered(((Boolean)value).booleanValue());
                break;
            }
            case 14: {
                associationEnd.setUnique(((Boolean)value).booleanValue());
                break;
            }
            default: {
                return;
            }
        }
    }
}

