/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ObAggregationKindEnum;
import com.modeliosoft.modelio.api.model.uml.statik.ObKindOfAccessEnum;
import com.modeliosoft.modelio.api.model.uml.statik.ObVisibilityModeEnum;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IElementFilter;
import com.modeliosoft.modelio.core.ui.MetamodelLabels;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml.AssociationEndNPropertyModel;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class AssociationEndNPropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"Association", "AssociationName", "Class", "Role", "Visibility", "MultiplicityMin", "MultiplicityMax", "AssociationType", "IsModifiable", "IsNavigable", "AccessMode", "IsAbstract", "IsClass", "IsOrdered", "IsUnique"};
    private List<IAssociationEnd> displayedRoles;
    private IAssociationEnd element;
    private IAssociation theAssociation;
    private StringType labelStringType = null;
    private StringType stringType = null;
    private BooleanType booleanType = null;
    private SingleElementType classifierType = null;
    private EnumType visibilityType = null;
    private EnumType kindOfAccessType = null;
    private EnumType kindOfAssociationType = null;
    private ListStringType cardinalityMinType = null;
    private ListStringType cardinalityMaxType = null;

    public AssociationEndNPropertyModel(IAssociationEnd element) {
        this.element = element;
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.booleanType = new BooleanType();
        this.classifierType = new SingleElementType(false, IClassifier.class);
        this.classifierType.setElementFilter((IElementFilter)new ClassifierTypeFilter(this));
        this.visibilityType = new EnumType(false, ObVisibilityModeEnum.class);
        this.kindOfAccessType = new EnumType(false, ObKindOfAccessEnum.class);
        this.kindOfAssociationType = new EnumType(false, ObAggregationKindEnum.class);
        ArrayList<String> cardinalityMinValues = new ArrayList<String>();
        cardinalityMinValues.add("0");
        cardinalityMinValues.add("1");
        this.cardinalityMinType = new ListStringType(true, cardinalityMinValues);
        ArrayList<String> cardinalityMaxValues = new ArrayList<String>();
        cardinalityMaxValues.add("1");
        cardinalityMaxValues.add("*");
        this.cardinalityMaxType = new ListStringType(true, cardinalityMaxValues);
        this.theAssociation = element.getRelated();
        if (this.theAssociation != null) {
            ObList roles = this.theAssociation.getConnection();
            this.displayedRoles = new ArrayList(roles.size());
            this.displayedRoles.add(this.element);
            for (IAssociationEnd r : roles) {
                if (r.equals((Object)this.element)) continue;
                this.displayedRoles.add(r);
            }
        }
    }

    public int getColumnNumber() {
        return this.displayedRoles.size() + 1;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
        }
        switch (row) {
            case 0: {
                return this.labelStringType;
            }
            case 1: {
                return this.stringType;
            }
            case 2: {
                return this.classifierType;
            }
            case 3: {
                return this.stringType;
            }
            case 4: {
                return this.visibilityType;
            }
            case 5: {
                return this.cardinalityMinType;
            }
            case 6: {
                return this.cardinalityMaxType;
            }
            case 7: {
                return this.kindOfAssociationType;
            }
            case 8: {
                return this.booleanType;
            }
            case 9: {
                return this.booleanType;
            }
            case 10: {
                return this.kindOfAccessType;
            }
            case 11: {
                return this.booleanType;
            }
            case 12: {
                return this.booleanType;
            }
            case 13: {
                return this.booleanType;
            }
            case 14: {
                return this.booleanType;
            }
        }
        return null;
    }

    public Object getValueAt(int row, int col) {
        if (row == 1) {
            if (col == 0) {
                return PROPERTIES[row];
            }
            if (col == 1) {
                return this.theAssociation.getName();
            }
            return "";
        }
        switch (col) {
            case 0: {
                return PROPERTIES[row];
            }
        }
        return this.getPropertyValue(row, (IAssociationEnd)this.displayedRoles.get(col - 1));
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (row == 1) {
            if (col == 1) {
                IModelingSession modelingSession = Edition.getInstance().getSession();
                IElementStatus status = modelingSession.getElementStatus((IElement)this.theAssociation);
                return status.isModifiable();
            }
            return false;
        }
        IAssociationEnd relatedEnd = (IAssociationEnd)this.displayedRoles.get(col - 1);
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IElementStatus status = modelingSession.getElementStatus((IElement)relatedEnd);
        return status.isModifiable();
    }

    public void setValueAt(int row, int col, Object value) {
        switch (col) {
            case 0: {
                return;
            }
        }
        this.setPropertyValue(row, (IAssociationEnd)this.displayedRoles.get(col - 1), value);
    }

    private Object getPropertyValue(int row, IAssociationEnd associationEnd) {
        switch (row) {
            case 0: {
                IClassifier type = associationEnd.getOwner();
                if (type == null) {
                    return "";
                }
                return MessageFormat.format(MetamodelLabels.getString((String)"Title.from"), type.getName());
            }
            case 1: {
                if (this.theAssociation != null) {
                    return this.theAssociation.getName();
                }
                return MetamodelLabels.getString((String)"AssociationEnd.NoAssociation");
            }
            case 2: {
                return associationEnd.getOwner();
            }
            case 3: {
                return associationEnd.getName();
            }
            case 4: {
                return associationEnd.getVisibility();
            }
            case 5: {
                return associationEnd.getMultiplicityMin();
            }
            case 6: {
                return associationEnd.getMultiplicityMax();
            }
            case 7: {
                return associationEnd.getAggregation();
            }
            case 8: {
                return associationEnd.isChangeable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return associationEnd.isNavigable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return associationEnd.getChangeable();
            }
            case 11: {
                return associationEnd.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return associationEnd.isClass() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return associationEnd.isOrdered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return associationEnd.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private void setPropertyValue(int row, IAssociationEnd associationEnd, Object value) {
        switch (row) {
            case 0: {
                return;
            }
            case 1: {
                if (this.theAssociation == null) break;
                this.theAssociation.setName((String)value);
                break;
            }
            case 2: {
                associationEnd.setOwner((IClassifier)value);
                break;
            }
            case 3: {
                associationEnd.setName(String.valueOf(value));
                break;
            }
            case 4: {
                associationEnd.setVisibility((ObVisibilityModeEnum)value);
                break;
            }
            case 5: {
                associationEnd.setMultiplicityMin(String.valueOf(value));
                break;
            }
            case 6: {
                associationEnd.setMultiplicityMax(String.valueOf(value));
                break;
            }
            case 7: {
                associationEnd.setAggregation((ObAggregationKindEnum)value);
                break;
            }
            case 8: {
                associationEnd.setChangeable(((Boolean)value).booleanValue());
                break;
            }
            case 9: {
                associationEnd.setNavigable(((Boolean)value).booleanValue());
                break;
            }
            case 10: {
                associationEnd.setChangeable((ObKindOfAccessEnum)value);
                break;
            }
            case 11: {
                associationEnd.setAbstract(((Boolean)value).booleanValue());
                break;
            }
            case 12: {
                associationEnd.setClass(((Boolean)value).booleanValue());
                break;
            }
            case 13: {
                associationEnd.setOrdered(((Boolean)value).booleanValue());
                break;
            }
            case 14: {
                associationEnd.setUnique(((Boolean)value).booleanValue());
                break;
            }
            default: {
                return;
            }
        }
    }
}

