/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IConnector;
import com.modeliosoft.modelio.api.model.uml.statik.IConnectorEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;

public class ConnectorEnd2PropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"ConnectorEnd", "LinkName", "Base", "ConnectorRepresentedFeature", "Linked", "Name", "ConnectorEndRepresentedFeature", "MultiplicityMin", "MultiplicityMax", "IsNavigable", "IsOrdered", "IsUnique"};
    private IConnectorEnd theConnectorEnd;
    private ILink theLink;
    private StringType labelStringType = null;
    private StringType stringType = null;
    private BooleanType booleanType = null;
    private ListStringType cardinalityMinType = null;
    private ListStringType cardinalityMaxType = null;
    private SingleElementType linkedType = null;
    private SingleElementType assocType = null;
    private SingleElementType connectorRepresentedFeatureType = null;
    private SingleElementType connectorEndRepresentedFeatureType = null;

    public int getColumnNumber() {
        return 3;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public Object getValueAt(int row, int col) {
        if (row == 1 || row == 2 || row == 3) {
            return this.getLinkPropertyValue(row, col);
        }
        switch (col) {
            case 0: {
                if (row == 0) {
                    return String.valueOf(this.theConnectorEnd.getName()) + " association";
                }
                return PROPERTIES[row];
            }
            case 1: {
                ILinkEnd relatedEnd = this.getRelatedEnd((ILinkEnd)this.theConnectorEnd);
                if (relatedEnd != null) {
                    return this.getPropertyValue(row, relatedEnd);
                }
                return null;
            }
            case 2: {
                return this.getPropertyValue(row, (ILinkEnd)this.theConnectorEnd);
            }
        }
        return null;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: 
            case 2: {
                switch (row) {
                    case 0: {
                        return this.labelStringType;
                    }
                    case 1: {
                        return this.stringType;
                    }
                    case 2: {
                        if (col == 1) {
                            return this.assocType;
                        }
                        return this.stringType;
                    }
                    case 3: {
                        if (col == 1) {
                            return this.connectorRepresentedFeatureType;
                        }
                        return this.stringType;
                    }
                    case 4: {
                        return this.linkedType;
                    }
                    case 5: {
                        return this.stringType;
                    }
                    case 6: {
                        return this.connectorEndRepresentedFeatureType;
                    }
                    case 7: {
                        return this.cardinalityMinType;
                    }
                    case 8: {
                        return this.cardinalityMaxType;
                    }
                    case 9: {
                        return this.booleanType;
                    }
                    case 10: {
                        return this.booleanType;
                    }
                    case 11: {
                        return this.booleanType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        switch (col) {
            case 0: {
                return;
            }
            case 1: {
                ILinkEnd relatedEnd = this.getRelatedEnd((ILinkEnd)this.theConnectorEnd);
                if (relatedEnd != null) {
                    this.setPropertyValue(row, relatedEnd, value);
                }
                return;
            }
            case 2: {
                this.setPropertyValue(row, (ILinkEnd)this.theConnectorEnd, value);
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEditable(int row, int col) {
        IModelingSession modelingSession;
        IElementStatus status;
        if (col == 0) {
            return false;
        }
        if (row == 1 || row == 2 || row == 3) {
            if (col != 1) return false;
            IModelingSession modelingSession2 = Edition.getInstance().getSession();
            if (this.theLink == null) {
                return false;
            }
            IElementStatus status2 = modelingSession2.getElementStatus((IElement)this.theLink);
            if (status2.isModifiable()) return true;
            return false;
        }
        if (col == 1) {
            ILinkEnd relatedEnd = this.getRelatedEnd((ILinkEnd)this.theConnectorEnd);
            IModelingSession modelingSession3 = Edition.getInstance().getSession();
            IElementStatus status3 = modelingSession3.getElementStatus((IElement)relatedEnd);
            if (status3.isModifiable()) return true;
            return false;
        }
        if (col != 2 || (status = (modelingSession = Edition.getInstance().getSession()).getElementStatus((IElement)this.theConnectorEnd)).isModifiable()) return true;
        return false;
    }

    public ConnectorEnd2PropertyModel(IConnectorEnd theConnectorEnd) {
        this.theConnectorEnd = theConnectorEnd;
        this.theLink = theConnectorEnd.getLinkNode();
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.booleanType = new BooleanType();
        this.assocType = new SingleElementType(true, IAssociation.class);
        this.linkedType = new SingleElementType(false, IInstance.class);
        ArrayList<Class<ILink>> connectorRepresentedFeatureValues = new ArrayList<Class<ILink>>();
        connectorRepresentedFeatureValues.add(IAttribute.class);
        connectorRepresentedFeatureValues.add(IAssociation.class);
        connectorRepresentedFeatureValues.add(ILink.class);
        this.connectorRepresentedFeatureType = new SingleElementType(true, connectorRepresentedFeatureValues);
        ArrayList<Class<ILinkEnd>> connectorEndRepresentedFeatureValues = new ArrayList<Class<ILinkEnd>>();
        connectorEndRepresentedFeatureValues.add(IAttribute.class);
        connectorEndRepresentedFeatureValues.add(IAssociationEnd.class);
        connectorEndRepresentedFeatureValues.add(ILinkEnd.class);
        this.connectorEndRepresentedFeatureType = new SingleElementType(true, connectorEndRepresentedFeatureValues);
        ArrayList<String> cardinalityMinValues = new ArrayList<String>();
        cardinalityMinValues.add("0");
        cardinalityMinValues.add("1");
        this.cardinalityMinType = new ListStringType(true, cardinalityMinValues);
        ArrayList<String> cardinalityMaxValues = new ArrayList<String>();
        cardinalityMaxValues.add("1");
        cardinalityMaxValues.add("*");
        this.cardinalityMaxType = new ListStringType(true, cardinalityMaxValues);
    }

    private Object getLinkPropertyValue(int row, int col) {
        if (col == 0) {
            return PROPERTIES[row];
        }
        if (col == 1) {
            return this.getPropertyValue(row, (ILinkEnd)this.theConnectorEnd);
        }
        if (row == 1) {
            return "";
        }
        return "";
    }

    private Object getPropertyValue(int row, ILinkEnd aLinkEnd) {
        ILinkEnd relatedEnd = this.getRelatedEnd(aLinkEnd);
        switch (row) {
            case 0: {
                if (relatedEnd == null) {
                    return "";
                }
                IInstance type = relatedEnd.getLinked();
                if (type == null) {
                    return "";
                }
                if (aLinkEnd == this.theConnectorEnd) {
                    return "To: " + type.getName();
                }
                return "From: " + type.getName();
            }
            case 1: {
                if (this.theLink == null) {
                    return "<no link>";
                }
                return this.theLink.getName();
            }
            case 2: {
                if (this.theLink == null) {
                    return null;
                }
                return this.theLink.getBase();
            }
            case 3: {
                if (this.theLink instanceof IConnector) {
                    return ((IConnector)this.theLink).getRepresentedFeature();
                }
                return null;
            }
            case 4: {
                if (relatedEnd != null) {
                    IInstance relatedInstance = relatedEnd.getLinked();
                    return relatedInstance;
                }
                return null;
            }
            case 5: {
                return aLinkEnd.getName();
            }
            case 6: {
                if (aLinkEnd instanceof IConnectorEnd) {
                    return ((IConnectorEnd)aLinkEnd).getRepresentedFeature();
                }
                return null;
            }
            case 7: {
                return aLinkEnd.getMultiplicityMin();
            }
            case 8: {
                return aLinkEnd.getMultiplicityMax();
            }
            case 9: {
                return aLinkEnd.isNavigable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return aLinkEnd.isOrdered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return aLinkEnd.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private ILinkEnd getRelatedEnd(ILinkEnd associationEnd) {
        ILink association = associationEnd.getLinkNode();
        if (association != null) {
            ObList associationEndList = association.getConnection();
            ILinkEnd end = null;
            int i = 0;
            while (i < associationEndList.size()) {
                end = (ILinkEnd)associationEndList.get(i);
                if (end != null && !end.equals((Object)associationEnd)) {
                    return end;
                }
                ++i;
            }
        }
        return null;
    }

    private void setPropertyValue(int row, ILinkEnd linkEnd, Object value) {
        switch (row) {
            case 0: {
                return;
            }
            case 1: {
                if (this.theLink == null) break;
                this.theLink.setName((String)value);
                break;
            }
            case 2: {
                if (this.theLink == null) break;
                this.theLink.setBase((IAssociation)value);
                break;
            }
            case 3: {
                if (!(this.theLink instanceof IConnector)) break;
                ((IConnector)this.theLink).setRepresentedFeature((IModelElement)value);
                break;
            }
            case 4: {
                ILinkEnd relatedEnd = this.getRelatedEnd(linkEnd);
                if (relatedEnd == null) break;
                relatedEnd.setLinked((IInstance)value);
                break;
            }
            case 5: {
                linkEnd.setName(String.valueOf(value));
                break;
            }
            case 6: {
                if (!(linkEnd instanceof IConnectorEnd)) break;
                ((IConnectorEnd)linkEnd).setRepresentedFeature((IModelElement)value);
                break;
            }
            case 7: {
                linkEnd.setMultiplicityMin(String.valueOf(value));
                break;
            }
            case 8: {
                linkEnd.setMultiplicityMax(String.valueOf(value));
                break;
            }
            case 9: {
                linkEnd.setNavigable(((Boolean)value).booleanValue());
                break;
            }
            case 10: {
                linkEnd.setOrdered(((Boolean)value).booleanValue());
                break;
            }
            case 11: {
                linkEnd.setUnique(((Boolean)value).booleanValue());
                break;
            }
            default: {
                return;
            }
        }
    }
}

