/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IConnector;
import com.modeliosoft.modelio.api.model.uml.statik.IConnectorEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.List;

public class ConnectorEndNPropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"LinkEnd", "LinkName", "Base", "ConnectorRepresentedFeature", "Linked", "Name", "ConnectorEndRepresentedFeature", "MultiplicityMin", "MultiplicityMax", "IsNavigable", "IsOrdered", "IsUnique"};
    private IConnectorEnd theConnectorEnd;
    private ILink theLink;
    private List<ILinkEnd> displayedRoles;
    private StringType labelStringType = null;
    private StringType stringType = null;
    private BooleanType booleanType = null;
    private ListStringType cardinalityMinType = null;
    private ListStringType cardinalityMaxType = null;
    private SingleElementType linkedType = null;
    private SingleElementType assocType = null;
    private SingleElementType connectorRepresentedFeatureType = null;
    private SingleElementType connectorEndRepresentedFeatureType = null;

    public int getColumnNumber() {
        return this.displayedRoles.size() + 1;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public Object getValueAt(int row, int col) {
        if (row == 1 || row == 2 || row == 3) {
            return this.getLinkPropertyValue(row, col);
        }
        switch (col) {
            case 0: {
                if (row == 0) {
                    return String.valueOf(this.theConnectorEnd.getName()) + " link";
                }
                return PROPERTIES[row];
            }
        }
        return this.getPropertyValue(row, (ILinkEnd)this.displayedRoles.get(col - 1));
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
        }
        switch (row) {
            case 0: {
                return this.labelStringType;
            }
            case 1: {
                return this.stringType;
            }
            case 2: {
                if (col == 1) {
                    return this.assocType;
                }
                return this.stringType;
            }
            case 3: {
                if (col == 1) {
                    return this.connectorRepresentedFeatureType;
                }
                return this.stringType;
            }
            case 4: {
                return this.linkedType;
            }
            case 5: {
                return this.stringType;
            }
            case 6: {
                return this.connectorEndRepresentedFeatureType;
            }
            case 7: {
                return this.cardinalityMinType;
            }
            case 8: {
                return this.cardinalityMaxType;
            }
            case 9: {
                return this.booleanType;
            }
            case 10: {
                return this.booleanType;
            }
            case 11: {
                return this.booleanType;
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        switch (col) {
            case 0: {
                return;
            }
        }
        this.setPropertyValue(row, (ILinkEnd)this.displayedRoles.get(col - 1), value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (row == 1 || row == 2) {
            if (col != 1) return false;
            IModelingSession modelingSession = Edition.getInstance().getSession();
            if (this.theLink == null) {
                return false;
            }
            IElementStatus status = modelingSession.getElementStatus((IElement)this.theLink);
            if (status.isModifiable()) return true;
            return false;
        }
        if (col != 1) return true;
        ILinkEnd relatedEnd = (ILinkEnd)this.displayedRoles.get(col - 1);
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IElementStatus status = modelingSession.getElementStatus((IElement)relatedEnd);
        if (status.isModifiable()) return true;
        return false;
    }

    public ConnectorEndNPropertyModel(IConnectorEnd theLinkEnd) {
        this.theConnectorEnd = theLinkEnd;
        this.theLink = theLinkEnd.getLinkNode();
        this.theLink = theLinkEnd.getLinkNode();
        if (this.theLink != null) {
            ObList roles = this.theLink.getConnection();
            this.displayedRoles = new ArrayList(roles.size());
            this.displayedRoles.add(this.theConnectorEnd);
            for (ILinkEnd r : roles) {
                if (r.equals((Object)this.theConnectorEnd)) continue;
                this.displayedRoles.add(r);
            }
        }
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.booleanType = new BooleanType();
        this.assocType = new SingleElementType(true, IAssociation.class);
        this.linkedType = new SingleElementType(false, IInstance.class);
        ArrayList<Class<ILink>> connectorRepresentedFeatureValues = new ArrayList<Class<ILink>>();
        connectorRepresentedFeatureValues.add(IAttribute.class);
        connectorRepresentedFeatureValues.add(IAssociation.class);
        connectorRepresentedFeatureValues.add(ILink.class);
        this.connectorRepresentedFeatureType = new SingleElementType(true, connectorRepresentedFeatureValues);
        ArrayList<Class<ILinkEnd>> connectorEndRepresentedFeatureValues = new ArrayList<Class<ILinkEnd>>();
        connectorEndRepresentedFeatureValues.add(IAttribute.class);
        connectorEndRepresentedFeatureValues.add(IAssociationEnd.class);
        connectorEndRepresentedFeatureValues.add(ILinkEnd.class);
        this.connectorEndRepresentedFeatureType = new SingleElementType(true, connectorEndRepresentedFeatureValues);
        ArrayList<String> cardinalityMinValues = new ArrayList<String>();
        cardinalityMinValues.add("0");
        cardinalityMinValues.add("1");
        this.cardinalityMinType = new ListStringType(true, cardinalityMinValues);
        ArrayList<String> cardinalityMaxValues = new ArrayList<String>();
        cardinalityMaxValues.add("1");
        cardinalityMaxValues.add("*");
        this.cardinalityMaxType = new ListStringType(true, cardinalityMaxValues);
    }

    private Object getLinkPropertyValue(int row, int col) {
        if (col == 0) {
            return PROPERTIES[row];
        }
        if (col == 1) {
            return this.getPropertyValue(row, (ILinkEnd)this.theConnectorEnd);
        }
        if (row == 1) {
            return "";
        }
        return "";
    }

    private Object getPropertyValue(int row, ILinkEnd aLinkEnd) {
        switch (row) {
            case 0: {
                IInstance type = aLinkEnd.getLinked();
                if (type == null) {
                    return "";
                }
                if (aLinkEnd == this.theConnectorEnd) {
                    return "To: " + type.getName();
                }
                return "From: " + type.getName();
            }
            case 1: {
                if (this.theLink == null) {
                    return "<no link>";
                }
                return this.theLink.getName();
            }
            case 2: {
                if (this.theLink == null) {
                    return null;
                }
                return this.theLink.getBase();
            }
            case 3: {
                if (this.theLink instanceof IConnector) {
                    return ((IConnector)this.theLink).getRepresentedFeature();
                }
                return null;
            }
            case 4: {
                IInstance relatedInstance = aLinkEnd.getLinked();
                return relatedInstance;
            }
            case 5: {
                return aLinkEnd.getName();
            }
            case 6: {
                if (aLinkEnd instanceof IConnectorEnd) {
                    return ((IConnectorEnd)aLinkEnd).getRepresentedFeature();
                }
                return null;
            }
            case 7: {
                return aLinkEnd.getMultiplicityMin();
            }
            case 8: {
                return aLinkEnd.getMultiplicityMax();
            }
            case 9: {
                return aLinkEnd.isNavigable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return aLinkEnd.isOrdered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return aLinkEnd.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private void setPropertyValue(int row, ILinkEnd linkEnd, Object value) {
        switch (row) {
            case 0: {
                return;
            }
            case 1: {
                if (this.theLink == null) break;
                this.theLink.setName((String)value);
                break;
            }
            case 2: {
                if (this.theLink == null) break;
                this.theLink.setBase((IAssociation)value);
                break;
            }
            case 3: {
                if (!(this.theLink instanceof IConnector)) break;
                ((IConnector)this.theLink).setRepresentedFeature((IModelElement)value);
                break;
            }
            case 4: {
                linkEnd.setLinked((IInstance)value);
                break;
            }
            case 5: {
                linkEnd.setName(String.valueOf(value));
                break;
            }
            case 6: {
                if (!(linkEnd instanceof IConnectorEnd)) break;
                ((IConnectorEnd)linkEnd).setRepresentedFeature((IModelElement)value);
                break;
            }
            case 7: {
                linkEnd.setMultiplicityMin(String.valueOf(value));
                break;
            }
            case 8: {
                linkEnd.setMultiplicityMax(String.valueOf(value));
                break;
            }
            case 9: {
                linkEnd.setNavigable(((Boolean)value).booleanValue());
                break;
            }
            case 10: {
                linkEnd.setOrdered(((Boolean)value).booleanValue());
                break;
            }
            case 11: {
                linkEnd.setUnique(((Boolean)value).booleanValue());
                break;
            }
            default: {
                return;
            }
        }
    }
}

