/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityEdge;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.information.IInformationFlow;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.MultipleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.List;

public class InformationFlowPropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"InformationFlow", "Name", "Conveyed", "InformationSource", "Owner", "InformationTarget", "Realizing"};
    private IInformationFlow theInformationFlow;
    private StringType labelStringType = null;
    private StringType stringType = null;
    private MultipleElementType conveyedType = null;
    private SingleElementType informationSourceType = null;
    private SingleElementType ownerType = null;
    private SingleElementType informationTargetType = null;
    private SingleElementType realizingType = null;

    public InformationFlowPropertyModel(IInformationFlow theInformationFlow) {
        this.theInformationFlow = theInformationFlow;
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.conveyedType = new MultipleElementType(true, (IModelElement)theInformationFlow, "Conveyed", IClassifier.class);
        this.informationSourceType = new SingleElementType(false, IModelElement.class);
        this.ownerType = new SingleElementType(true, INameSpace.class);
        this.informationTargetType = new SingleElementType(false, IModelElement.class);
        ArrayList<Class<ICommunicationMessage>> realizingTypes = new ArrayList<Class<ICommunicationMessage>>();
        realizingTypes.add(ILink.class);
        realizingTypes.add(IAssociation.class);
        realizingTypes.add(IActivityEdge.class);
        realizingTypes.add(IMessage.class);
        realizingTypes.add(ICommunicationMessage.class);
        this.realizingType = new SingleElementType(true, realizingTypes);
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return PROPERTIES[row];
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return "Value";
                    }
                    case 1: {
                        return this.theInformationFlow.getName();
                    }
                    case 2: {
                        return this.theInformationFlow.getConveyed();
                    }
                    case 3: {
                        ObList sources = this.theInformationFlow.getInformationSource();
                        if (sources != null && sources.size() > 0) {
                            return sources.get(0);
                        }
                        return null;
                    }
                    case 4: {
                        return this.theInformationFlow.getOwner();
                    }
                    case 5: {
                        ObList targets = this.theInformationFlow.getInformationTarget();
                        if (targets != null && targets.size() > 0) {
                            return targets.get(0);
                        }
                        return null;
                    }
                    case 6: {
                        return this.getRealizing();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.labelStringType;
                    }
                    case 1: {
                        return this.stringType;
                    }
                    case 2: {
                        return this.conveyedType;
                    }
                    case 3: {
                        return this.informationSourceType;
                    }
                    case 4: {
                        return this.ownerType;
                    }
                    case 5: {
                        return this.informationTargetType;
                    }
                    case 6: {
                        return this.realizingType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        block0 : switch (col) {
            case 0: {
                return;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.theInformationFlow.setName((String)value);
                        break block0;
                    }
                    case 2: {
                        for (IClassifier s : this.theInformationFlow.getConveyed()) {
                            this.theInformationFlow.removeConveyed(s);
                        }
                        List newcontent = (List)value;
                        for (IClassifier s : newcontent) {
                            this.theInformationFlow.addConveyed(s);
                        }
                        break block0;
                    }
                    case 3: {
                        this.theInformationFlow.removeInformationSource((IModelElement)this.theInformationFlow.getInformationSource().get(0));
                        this.theInformationFlow.addInformationSource((IModelElement)value);
                        break block0;
                    }
                    case 4: {
                        this.theInformationFlow.setOwner((INameSpace)value);
                        break block0;
                    }
                    case 5: {
                        this.theInformationFlow.removeInformationTarget((IModelElement)this.theInformationFlow.getInformationTarget().get(0));
                        this.theInformationFlow.addInformationTarget((IModelElement)value);
                        break block0;
                    }
                    case 6: {
                        this.setRealizing(this.theInformationFlow, value);
                        break block0;
                    }
                    default: {
                        return;
                    }
                }
            }
            default: {
                return;
            }
        }
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IElementStatus status = modelingSession.getElementStatus((IElement)this.theInformationFlow);
        return status.isModifiable();
    }

    private IModelElement getRealizing() {
        IModelElement ret = null;
        ObList linkList = this.theInformationFlow.getRealizingLink();
        if (linkList.size() > 0 && (ret = (IModelElement)linkList.get(0)) != null) {
            return ret;
        }
        ObList assocList = this.theInformationFlow.getRealizingAssociation();
        if (assocList.size() > 0 && (ret = (IModelElement)assocList.get(0)) != null) {
            return ret;
        }
        ObList edgeList = this.theInformationFlow.getRealizingActivityEdge();
        if (edgeList.size() > 0 && (ret = (IModelElement)edgeList.get(0)) != null) {
            return ret;
        }
        ObList messageList = this.theInformationFlow.getRealizingMessage();
        if (messageList.size() > 0 && (ret = (IModelElement)messageList.get(0)) != null) {
            return ret;
        }
        ObList communicationMessageList = this.theInformationFlow.getRealizingCommunicationMessage();
        if (communicationMessageList.size() > 0 && (ret = (IModelElement)communicationMessageList.get(0)) != null) {
            return ret;
        }
        return null;
    }

    private void setRealizing(IInformationFlow theInformationFlow, Object value) {
        ObList communicationMessageList;
        ObList messageList;
        ObList edgeList;
        ObList assocList;
        ObList linkList = theInformationFlow.getRealizingLink();
        if (linkList.size() > 0) {
            ILink old1 = (ILink)linkList.get(0);
            if (old1.equals(value)) {
                return;
            }
            theInformationFlow.removeRealizingLink(old1);
        }
        if ((assocList = theInformationFlow.getRealizingAssociation()).size() > 0) {
            IAssociation old2 = (IAssociation)assocList.get(0);
            if (old2.equals(value)) {
                return;
            }
            theInformationFlow.removeRealizingAssociation(old2);
        }
        if ((edgeList = theInformationFlow.getRealizingActivityEdge()).size() > 0) {
            IActivityEdge old3 = (IActivityEdge)edgeList.get(0);
            if (old3.equals(value)) {
                return;
            }
            theInformationFlow.removeRealizingActivityEdge(old3);
        }
        if ((messageList = theInformationFlow.getRealizingMessage()).size() > 0) {
            IMessage old4 = (IMessage)messageList.get(0);
            if (old4.equals(value)) {
                return;
            }
            theInformationFlow.removeRealizingMessage(old4);
        }
        if ((communicationMessageList = theInformationFlow.getRealizingCommunicationMessage()).size() > 0) {
            ICommunicationMessage old5 = (ICommunicationMessage)communicationMessageList.get(0);
            if (old5.equals(value)) {
                return;
            }
            theInformationFlow.removeRealizingCommunicationMessage(old5);
        }
        if (value != null) {
            if (ILink.class.isAssignableFrom(value.getClass())) {
                theInformationFlow.addRealizingLink((ILink)value);
            } else if (IAssociation.class.isAssignableFrom(value.getClass())) {
                theInformationFlow.addRealizingAssociation((IAssociation)value);
            } else if (IActivityEdge.class.isAssignableFrom(value.getClass())) {
                theInformationFlow.addRealizingActivityEdge((IActivityEdge)value);
            } else if (IMessage.class.isAssignableFrom(value.getClass())) {
                theInformationFlow.addRealizingMessage((IMessage)value);
            } else if (ICommunicationMessage.class.isAssignableFrom(value.getClass())) {
                theInformationFlow.addRealizingCommunicationMessage((ICommunicationMessage)value);
            }
        }
    }
}

