/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IElementFilter;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml.InstancePropertyModel;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;

public class InstancePropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"Instance", "Name", "Base", "Value", "MultiplicityMin", "MultiplicityMax", "IsConstant"};
    private IInstance theInstance;
    private StringType labelStringType = null;
    private StringType stringType = null;
    private BooleanType booleanType = null;
    private SingleElementType baseType = null;
    private ListStringType cardinalityMinType = null;
    private ListStringType cardinalityMaxType = null;

    public InstancePropertyModel(IInstance theInstance) {
        this.theInstance = theInstance;
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.booleanType = new BooleanType();
        this.baseType = new SingleElementType(true, INameSpace.class);
        this.baseType.setElementFilter((IElementFilter)new BaseTypeFilter(this));
        ArrayList<String> cardinalityMinValues = new ArrayList<String>();
        cardinalityMinValues.add("0");
        cardinalityMinValues.add("1");
        this.cardinalityMinType = new ListStringType(true, cardinalityMinValues);
        ArrayList<String> cardinalityMaxValues = new ArrayList<String>();
        cardinalityMaxValues.add("1");
        cardinalityMaxValues.add("*");
        this.cardinalityMaxType = new ListStringType(true, cardinalityMaxValues);
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return PROPERTIES[row];
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return "Value";
                    }
                    case 1: {
                        return this.theInstance.getName();
                    }
                    case 2: {
                        return this.theInstance.getBase();
                    }
                    case 3: {
                        return this.theInstance.getValue();
                    }
                    case 4: {
                        return this.theInstance.getMultiplicityMin();
                    }
                    case 5: {
                        return this.theInstance.getMultiplicityMax();
                    }
                    case 6: {
                        return this.theInstance.isConstant() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.labelStringType;
                    }
                    case 1: {
                        return this.stringType;
                    }
                    case 2: {
                        return this.baseType;
                    }
                    case 3: {
                        return this.stringType;
                    }
                    case 4: {
                        return this.cardinalityMinType;
                    }
                    case 5: {
                        return this.cardinalityMaxType;
                    }
                    case 6: {
                        return this.booleanType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        switch (col) {
            case 0: {
                return;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.theInstance.setName((String)value);
                        break;
                    }
                    case 2: {
                        this.theInstance.setBase((INameSpace)value);
                        break;
                    }
                    case 3: {
                        this.theInstance.setValue((String)value);
                        break;
                    }
                    case 4: {
                        this.theInstance.setMultiplicityMin((String)value);
                        break;
                    }
                    case 5: {
                        this.theInstance.setMultiplicityMax((String)value);
                        break;
                    }
                    case 6: {
                        this.theInstance.setConstant(((Boolean)value).booleanValue());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                return;
            }
        }
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IElementStatus status = modelingSession.getElementStatus((IElement)this.theInstance);
        return status.isModifiable();
    }
}

