/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.MetamodelLabels;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.text.MessageFormat;
import java.util.ArrayList;

public class LinkEnd2PropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"LinkEnd", "LinkName", "Link.Base", "Linked", "Name", "MultiplicityMin", "MultiplicityMax", "IsNavigable", "IsOrdered", "IsUnique"};
    private ILinkEnd theLinkEnd;
    private ILink theLink;
    private StringType labelStringType = null;
    private StringType stringType = null;
    private BooleanType booleanType = null;
    private ListStringType cardinalityMinType = null;
    private ListStringType cardinalityMaxType = null;
    private SingleElementType linkedType = null;
    private SingleElementType assocType = null;

    public LinkEnd2PropertyModel(ILinkEnd theLinkEnd) {
        this.theLinkEnd = theLinkEnd;
        this.theLink = theLinkEnd.getLinkNode();
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.booleanType = new BooleanType();
        this.assocType = new SingleElementType(true, IAssociation.class);
        this.linkedType = new SingleElementType(false, IInstance.class);
        ArrayList<String> cardinalityMinValues = new ArrayList<String>();
        cardinalityMinValues.add("0");
        cardinalityMinValues.add("1");
        this.cardinalityMinType = new ListStringType(true, cardinalityMinValues);
        ArrayList<String> cardinalityMaxValues = new ArrayList<String>();
        cardinalityMaxValues.add("1");
        cardinalityMaxValues.add("*");
        this.cardinalityMaxType = new ListStringType(true, cardinalityMaxValues);
    }

    private Object getLinkPropertyValue(int row, int col) {
        if (col == 0) {
            return PROPERTIES[row];
        }
        if (col == 1) {
            return this.getPropertyValue(row, this.theLinkEnd);
        }
        if (row == 1) {
            return "";
        }
        return "";
    }

    public int getColumnNumber() {
        return 3;
    }

    private Object getPropertyValue(int row, ILinkEnd aLinkEnd) {
        ILinkEnd relatedEnd = this.getRelatedEnd(aLinkEnd);
        switch (row) {
            case 0: {
                if (relatedEnd == null) {
                    return "";
                }
                IInstance type = relatedEnd.getLinked();
                if (type == null) {
                    return "";
                }
                if (aLinkEnd == this.theLinkEnd) {
                    return MessageFormat.format(MetamodelLabels.getString((String)"Title.to"), type.getName());
                }
                return MessageFormat.format(MetamodelLabels.getString((String)"Title.from"), type.getName());
            }
            case 1: {
                if (this.theLink == null) {
                    return MetamodelLabels.getString((String)"LinkEnd.NoLink");
                }
                return this.theLink.getName();
            }
            case 2: {
                if (this.theLink == null) {
                    return null;
                }
                return this.theLink.getBase();
            }
            case 3: {
                if (relatedEnd != null) {
                    IInstance relatedInstance = relatedEnd.getLinked();
                    return relatedInstance;
                }
                return null;
            }
            case 4: {
                return aLinkEnd.getName();
            }
            case 5: {
                return aLinkEnd.getMultiplicityMin();
            }
            case 6: {
                return aLinkEnd.getMultiplicityMax();
            }
            case 7: {
                return aLinkEnd.isNavigable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return aLinkEnd.isOrdered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return aLinkEnd.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private ILinkEnd getRelatedEnd(ILinkEnd associationEnd) {
        ILink association = associationEnd.getLinkNode();
        if (association != null) {
            ObList associationEndList = association.getConnection();
            ILinkEnd end = null;
            int i = 0;
            while (i < associationEndList.size()) {
                end = (ILinkEnd)associationEndList.get(i);
                if (end != null && !end.equals((Object)associationEnd)) {
                    return end;
                }
                ++i;
            }
        }
        return null;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: 
            case 2: {
                switch (row) {
                    case 0: {
                        return this.labelStringType;
                    }
                    case 1: {
                        return this.stringType;
                    }
                    case 2: {
                        if (col == 1) {
                            return this.assocType;
                        }
                        return this.stringType;
                    }
                    case 3: {
                        return this.linkedType;
                    }
                    case 4: {
                        return this.stringType;
                    }
                    case 5: {
                        return this.cardinalityMinType;
                    }
                    case 6: {
                        return this.cardinalityMaxType;
                    }
                    case 7: {
                        return this.booleanType;
                    }
                    case 8: {
                        return this.booleanType;
                    }
                    case 9: {
                        return this.booleanType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public Object getValueAt(int row, int col) {
        if (row == 1 || row == 2) {
            return this.getLinkPropertyValue(row, col);
        }
        switch (col) {
            case 0: {
                if (row == 0) {
                    return MessageFormat.format(MetamodelLabels.getString((String)"Title.LinkEnd"), this.theLinkEnd.getName());
                }
                return PROPERTIES[row];
            }
            case 1: {
                ILinkEnd relatedEnd = this.getRelatedEnd(this.theLinkEnd);
                if (relatedEnd != null) {
                    return this.getPropertyValue(row, relatedEnd);
                }
                return null;
            }
            case 2: {
                return this.getPropertyValue(row, this.theLinkEnd);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEditable(int row, int col) {
        IModelingSession modelingSession;
        IElementStatus status;
        if (col == 0) {
            return false;
        }
        if (row == 1 || row == 2) {
            if (col != 1) return false;
            IModelingSession modelingSession2 = Edition.getInstance().getSession();
            if (this.theLink == null) {
                return false;
            }
            IElementStatus status2 = modelingSession2.getElementStatus((IElement)this.theLink);
            if (status2.isModifiable()) return true;
            return false;
        }
        if (col == 1) {
            ILinkEnd relatedEnd = this.getRelatedEnd(this.theLinkEnd);
            IModelingSession modelingSession3 = Edition.getInstance().getSession();
            IElementStatus status3 = modelingSession3.getElementStatus((IElement)relatedEnd);
            if (status3.isModifiable()) return true;
            return false;
        }
        if (col != 2 || (status = (modelingSession = Edition.getInstance().getSession()).getElementStatus((IElement)this.theLinkEnd)).isModifiable()) return true;
        return false;
    }

    private void setPropertyValue(int row, ILinkEnd associationEnd, Object value) {
        switch (row) {
            case 0: {
                return;
            }
            case 1: {
                if (this.theLink == null) break;
                this.theLink.setName((String)value);
                break;
            }
            case 2: {
                if (this.theLink == null) break;
                this.theLink.setBase((IAssociation)value);
                break;
            }
            case 3: {
                ILinkEnd relatedEnd = this.getRelatedEnd(associationEnd);
                if (relatedEnd == null) break;
                relatedEnd.setLinked((IInstance)value);
                break;
            }
            case 4: {
                associationEnd.setName(String.valueOf(value));
                break;
            }
            case 5: {
                associationEnd.setMultiplicityMin(String.valueOf(value));
                break;
            }
            case 6: {
                associationEnd.setMultiplicityMax(String.valueOf(value));
                break;
            }
            case 7: {
                associationEnd.setNavigable(((Boolean)value).booleanValue());
                break;
            }
            case 8: {
                associationEnd.setOrdered(((Boolean)value).booleanValue());
                break;
            }
            case 9: {
                associationEnd.setUnique(((Boolean)value).booleanValue());
                break;
            }
            default: {
                return;
            }
        }
    }

    public void setValueAt(int row, int col, Object value) {
        switch (col) {
            case 0: {
                return;
            }
            case 1: {
                ILinkEnd relatedEnd = this.getRelatedEnd(this.theLinkEnd);
                if (relatedEnd != null) {
                    this.setPropertyValue(row, relatedEnd, value);
                }
                return;
            }
            case 2: {
                this.setPropertyValue(row, this.theLinkEnd, value);
                return;
            }
        }
    }
}

