/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessageEnd;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IFeature;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.api.model.uml.statik.IProvidedInterface;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ModelElementListType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.List;

public class MessagePropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"Message", "Name", "Invoked", "Argument", "SignalSignature"};
    private IMessage theMessage;
    private StringType labelStringType = null;
    private StringType stringType = null;
    private SingleElementType defaultInvokedType = null;
    private SingleElementType signalSignatureType = null;

    public MessagePropertyModel(IMessage theMessage) {
        this.theMessage = theMessage;
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.defaultInvokedType = new SingleElementType(true, IOperation.class);
        this.signalSignatureType = new SingleElementType(true, ISignal.class);
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return PROPERTIES[row];
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return "Value";
                    }
                    case 1: {
                        return this.theMessage.getName();
                    }
                    case 2: {
                        return this.theMessage.getInvoked();
                    }
                    case 3: {
                        return this.theMessage.getArgument();
                    }
                    case 4: {
                        return this.theMessage.getSignalSignature();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.labelStringType;
                    }
                    case 1: {
                        return this.stringType;
                    }
                    case 2: {
                        return this.getInvokedOperationType();
                    }
                    case 3: {
                        return this.stringType;
                    }
                    case 4: {
                        return this.signalSignatureType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        block0 : switch (col) {
            case 0: {
                return;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.theMessage.setName((String)value);
                        break block0;
                    }
                    case 2: {
                        this.theMessage.setInvoked((IOperation)value);
                        break block0;
                    }
                    case 3: {
                        this.theMessage.setArgument((String)value);
                        break block0;
                    }
                    case 4: {
                        this.theMessage.setSignalSignature((ISignal)value);
                        break block0;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IElementStatus status = modelingSession.getElementStatus((IElement)this.theMessage);
        return status.isModifiable();
    }

    private IPropertyType getInvokedOperationType() {
        IMessageEnd message = this.theMessage.getReceiveEvent();
        if (message == null) {
            return this.defaultInvokedType;
        }
        ObList lifelines = message.getCovered();
        if (lifelines.size() != 1) {
            return this.defaultInvokedType;
        }
        ILifeline lifeline = (ILifeline)lifelines.get(0);
        if (lifeline == null) {
            return this.defaultInvokedType;
        }
        IInstance instance = lifeline.getRepresented();
        if (instance == null) {
            return this.defaultInvokedType;
        }
        INameSpace ns = instance.getBase();
        if (!(ns instanceof IClassifier)) {
            return this.defaultInvokedType;
        }
        IClassifier classifier = (IClassifier)ns;
        List availableOperations = this.getAvailableOperations(classifier);
        ModelElementListType type = new ModelElementListType(true, IOperation.class, availableOperations);
        return type;
    }

    private List<IModelElement> getAvailableOperations(IClassifier classifier) {
        ArrayList<IModelElement> operationsList = new ArrayList<IModelElement>();
        if (classifier != null) {
            ObList classifierOperations = classifier.getPart(IOperation.class);
            for (IFeature feature : classifierOperations) {
                operationsList.add((IModelElement)feature);
            }
            ObList generalizations = classifier.getParent();
            for (IGeneralization generalization : generalizations) {
                INameSpace parentNameSpace = generalization.getSuperType();
                if (!(parentNameSpace instanceof IClassifier)) continue;
                operationsList.addAll(this.getAvailableOperations((IClassifier)parentNameSpace));
            }
            ObList bindableInstances = classifier.getInternalStructure();
            for (IBindableInstance bindableInstance : bindableInstances) {
                INameSpace biNs = bindableInstance.getBase();
                if (biNs instanceof IClassifier && !biNs.equals((Object)classifier)) {
                    operationsList.addAll(this.getAvailableOperations((IClassifier)biNs));
                }
                if (!(bindableInstance instanceof IPort)) continue;
                IPort port = (IPort)bindableInstance;
                ObList providedInterfaces = port.getProvided();
                for (IProvidedInterface providedInterface : providedInterfaces) {
                    ObList interfaces = providedInterface.getProvidedElement();
                    for (IInterface theInterface : interfaces) {
                        operationsList.addAll(this.getAvailableOperations((IClassifier)theInterface));
                    }
                }
            }
        }
        return operationsList;
    }
}

