/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.mdac.ModuleState;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;

public class ModulePropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"Module", "Name", "Version", "State"};
    private IModule theModule;
    private StringType labelStringType = null;
    private StringType stringType = null;
    private EnumType stateType = null;

    public ModulePropertyModel(IModule theModule) {
        this.theModule = theModule;
        this.labelStringType = new StringType(false);
        this.stringType = new StringType(true);
        this.stateType = new EnumType(false, ModuleState.class);
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.labelStringType;
                    }
                    case 1: {
                        return this.stringType;
                    }
                    case 2: {
                        return this.stringType;
                    }
                    case 3: {
                        return this.stateType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return PROPERTIES[row];
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return "Value";
                    }
                    case 1: {
                        return this.theModule.getName();
                    }
                    case 2: {
                        return new Version(this.theModule.getVersion());
                    }
                    case 3: {
                        return new MdacManager(Edition.getInstance().getSession()).isActivated(this.theModule) ? ModuleState.Activated : ModuleState.Desactivated;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        String moduleName = this.theModule.getName();
        if (row == 1) {
            if (moduleName != null && moduleName.equals("LocalModule")) {
                return false;
            }
            IElementStatus status = this.theModule.getElementStatus();
            return status.isModifiable() && !status.isRamcObject();
        }
        return false;
    }

    public void setValueAt(int row, int col, Object value) {
        switch (col) {
            case 0: {
                return;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.theModule.setName((String)value);
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        return;
                    }
                }
                return;
            }
        }
    }
}

