/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.model.analyst.IEnumeratedPropertyType;
import com.modeliosoft.modelio.api.model.analyst.IProperty;
import com.modeliosoft.modelio.api.model.analyst.IPropertyEnumerationLitteral;
import com.modeliosoft.modelio.api.model.analyst.IPropertyValue;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.ElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PropertyValuePropertyModel
implements IPropertyModel {
    private static final String[] PROPERTIES = new String[]{"PropertyValue", "Key", "Value"};
    private IPropertyValue thePropertyValue;
    private StringType labelStringType = new StringType(false);
    private StringType stringType = new StringType(true);
    private ElementType propertyKeyType = new SingleElementType(false, IProperty.class);
    private BooleanType booleanType = new BooleanType();
    private Map<IEnumeratedPropertyType, ListType> listType = new HashMap();

    public PropertyValuePropertyModel(IPropertyValue thePropertyValue) {
        this.thePropertyValue = thePropertyValue;
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return PROPERTIES.length;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return PROPERTIES[row];
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return "Value";
                    }
                    case 1: {
                        return this.thePropertyValue.getKey();
                    }
                    case 2: {
                        return this.thePropertyValue.getValue();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public Object getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.stringType;
                    }
                    case 1: {
                        return this.propertyKeyType;
                    }
                    case 2: {
                        return this.getPropertyType();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        block0 : switch (col) {
            case 0: {
                return;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.thePropertyValue.setKey((IProperty)value);
                        break block0;
                    }
                    case 2: {
                        this.thePropertyValue.setValue((String)value);
                        break block0;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
    }

    public boolean isEditable(int row, int col) {
        if (col == 0 || row != 2) {
            return false;
        }
        IElementStatus status = this.thePropertyValue.getElementStatus();
        return status.isModifiable();
    }

    private IPropertyType getPropertyType() {
        IProperty property = this.thePropertyValue.getKey();
        com.modeliosoft.modelio.api.model.analyst.IPropertyType propertyType = property.getType();
        if (propertyType instanceof IEnumeratedPropertyType) {
            IEnumeratedPropertyType enumeratedPropertyType = (IEnumeratedPropertyType)propertyType;
            ListType type = (ListType)this.listType.get(enumeratedPropertyType);
            if (type != null) {
                return type;
            }
            ArrayList<String> values = new ArrayList<String>();
            for (IPropertyEnumerationLitteral enumLitteral : enumeratedPropertyType.getLitteral()) {
                values.add(enumLitteral.getName());
            }
            type = new ListType(false, values);
            this.listType.put(enumeratedPropertyType, type);
            return type;
        }
        String propertyName = propertyType.getName();
        if (propertyName.equals("Boolean")) {
            return this.booleanType;
        }
        if (propertyName.equals("Text") || propertyName.equals("Integer") || propertyName.equals("Real") || propertyName.equals("Date")) {
            return this.stringType;
        }
        return this.stringType;
    }
}

