/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.analyst.IEnumeratedPropertyType;
import com.modeliosoft.modelio.api.model.analyst.IProperty;
import com.modeliosoft.modelio.api.model.analyst.IPropertyEnumerationLitteral;
import com.modeliosoft.modelio.api.model.analyst.IPropertySet;
import com.modeliosoft.modelio.api.model.analyst.IPropertyValue;
import com.modeliosoft.modelio.api.model.analyst.IPropertyValueSet;
import com.modeliosoft.modelio.api.model.analyst.IRequirement;
import com.modeliosoft.modelio.api.model.analyst.IRequirementContainer;
import com.modeliosoft.modelio.api.model.analyst.IRequirementElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListType;
import com.modeliosoft.modelio.core.ui.ktable.types.ModelElementListType;
import com.modeliosoft.modelio.core.ui.ktable.types.MultilineStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.ScopeRichTextType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequirementContainerPropertyModel
implements IPropertyModel {
    private IRequirementContainer theRequirementContainer;
    private StringType labelStringType = new StringType(false);
    private StringType stringType = new StringType(true);
    private BooleanType booleanType = new BooleanType();
    private Map<IEnumeratedPropertyType, ListType> listType = new HashMap();
    private List<String> properties = new ArrayList();

    public RequirementContainerPropertyModel(IRequirementContainer theRequirementContainer) {
        this.theRequirementContainer = theRequirementContainer;
        this.rebuildDisplayedProperties();
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return this.properties.size();
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.properties.get(row);
        }
        if (col == 1) {
            if (row == 0) {
                return "Value";
            }
            if (row == 1) {
                return this.theRequirementContainer.getName();
            }
            if (row == 2) {
                return this.theRequirementContainer.getType();
            }
            if (3 <= row && row < this.properties.size() - 1) {
                return this.getPropertyValue(row - 3);
            }
            if (row == this.properties.size() - 1) {
                return this.theRequirementContainer.getText();
            }
            return null;
        }
        return null;
    }

    public IPropertyType getTypeAt(int row, int col) {
        if (col == 0) {
            return this.labelStringType;
        }
        if (col == 1) {
            if (row == 0) {
                return this.labelStringType;
            }
            if (row == 1) {
                return this.stringType;
            }
            if (row == 2) {
                return this.getAvailableSets();
            }
            if (3 <= row && row < this.properties.size() - 1) {
                return this.getPropertyType(row - 3);
            }
            if (row == this.properties.size() - 1) {
                return new MultilineStringType((IModelElement)this.theRequirementContainer, (String)this.properties.get(row), true);
            }
            return null;
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        if (col == 0) {
            return;
        }
        if (col == 1) {
            if (row == 0) {
                return;
            }
            if (row == 1) {
                this.theRequirementContainer.setName(value.toString());
                return;
            }
            if (row == 2) {
                this.setType(value);
                return;
            }
            if (3 <= row && row < this.properties.size() - 1) {
                this.setPropertyValue(row - 3, value.toString());
                return;
            }
            if (row == this.properties.size() - 1) {
                this.theRequirementContainer.setText(value.toString());
            }
            return;
        }
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IElementStatus status = this.theRequirementContainer.getElementStatus();
        if (!status.isModifiable()) {
            return false;
        }
        String moduleName = "Analyst";
        Collection mdacs = modelingSession.getMdacRegistry().getStartedMdacs();
        for (IMdac mdac : mdacs) {
            if (!mdac.getName().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    private Object getPropertyValue(int propertyIndex) {
        IProperty property = (IProperty)this.theRequirementContainer.getType().getOwned().get(propertyIndex);
        boolean isBooleanProperty = property.getType().getName().equals("Boolean");
        IPropertyValueSet propertyValueSet = this.theRequirementContainer.getDefaultSet();
        if (propertyValueSet != null) {
            for (IPropertyValue propertyValue : propertyValueSet.getValue()) {
                String stringValue;
                if (!propertyValue.getKey().equals((Object)property) || (stringValue = propertyValue.getValue()) == null) continue;
                if (isBooleanProperty) {
                    return new Boolean(stringValue);
                }
                return stringValue;
            }
        }
        if (isBooleanProperty) {
            return new Boolean(property.getDefaultValue());
        }
        return property.getDefaultValue();
    }

    private IPropertyType getPropertyType(int propertyIndex) {
        IProperty property = (IProperty)this.theRequirementContainer.getType().getOwned().get(propertyIndex);
        com.modeliosoft.modelio.api.model.analyst.IPropertyType propertyType = property.getType();
        if (propertyType instanceof IEnumeratedPropertyType) {
            IEnumeratedPropertyType enumeratedPropertyType = (IEnumeratedPropertyType)propertyType;
            ListType type = (ListType)this.listType.get(enumeratedPropertyType);
            if (type != null) {
                return type;
            }
            ArrayList<String> values = new ArrayList<String>();
            for (IPropertyEnumerationLitteral enumLitteral : enumeratedPropertyType.getLitteral()) {
                values.add(enumLitteral.getName());
            }
            type = new ListType(false, values);
            this.listType.put(enumeratedPropertyType, type);
            return type;
        }
        String propertyName = propertyType.getName();
        if (propertyName.equals("Boolean")) {
            return this.booleanType;
        }
        if (propertyName.equals("MultiText")) {
            return new MultilineStringType((IModelElement)this.theRequirementContainer, "Text", true);
        }
        if (propertyName.equals("Text") || propertyName.equals("Integer") || propertyName.equals("Real") || propertyName.equals("Date")) {
            return this.stringType;
        }
        if (propertyName.equals("RichText")) {
            return new ScopeRichTextType((IModelElement)this.theRequirementContainer, true);
        }
        return this.stringType;
    }

    private void setPropertyValue(int propertyIndex, String value) {
        IPropertyValue propertyValue2;
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IProperty property = (IProperty)this.theRequirementContainer.getType().getOwned().get(propertyIndex);
        IPropertyValueSet propertyValueSet = this.theRequirementContainer.getDefaultSet();
        if (propertyValueSet == null) {
            propertyValueSet = modelingSession.getModelFactory().createPropertyValueSet();
            propertyValueSet.setType(this.theRequirementContainer.getType());
            this.theRequirementContainer.setDefaultSet(propertyValueSet);
        }
        for (IPropertyValue propertyValue2 : propertyValueSet.getValue()) {
            if (!propertyValue2.getKey().equals((Object)property)) continue;
            propertyValue2.setValue(value);
            return;
        }
        propertyValue2 = modelingSession.getModelFactory().createPropertyValue();
        propertyValue2.setKey(property);
        propertyValue2.setOwner(propertyValueSet);
        propertyValue2.setValue(value);
    }

    private void setType(Object newType) {
        if (newType == null) {
            this.theRequirementContainer.setType(null);
            if (this.theRequirementContainer.getDefaultSet() != null) {
                Edition.getInstance().getSession().getModelFactory().deleteElement((IElement)this.theRequirementContainer.getDefaultSet());
            }
            for (IRequirementElement requirementElement : this.theRequirementContainer.getOwned(IRequirement.class)) {
                IRequirement requirement = (IRequirement)requirementElement;
                this.applyNewPropertySet(requirement, null);
            }
        } else {
            IPropertySet newPropertySet = (IPropertySet)newType;
            this.theRequirementContainer.setType(newPropertySet);
            IPropertyValueSet oldPropertyValueSet = this.theRequirementContainer.getDefaultSet();
            if (oldPropertyValueSet == null) {
                oldPropertyValueSet = Edition.getInstance().getSession().getModelFactory().createPropertyValueSet();
                this.theRequirementContainer.setDefaultSet(oldPropertyValueSet);
                oldPropertyValueSet.setType(newPropertySet);
            } else {
                this.migrateOldValues(oldPropertyValueSet, newPropertySet);
            }
            this.createMissingValues(newPropertySet, oldPropertyValueSet);
            for (IRequirementElement requirementElement : this.theRequirementContainer.getOwned(IRequirement.class)) {
                IRequirement requirement = (IRequirement)requirementElement;
                this.applyNewPropertySet(requirement, newPropertySet);
            }
        }
        this.rebuildDisplayedProperties();
    }

    private void applyNewPropertySet(IRequirement requirement, IPropertySet newPropertySet) {
        if (newPropertySet == null) {
            Edition.getInstance().getSession().getModelFactory().deleteElement((IElement)requirement.getProperties());
        } else {
            IPropertyValueSet oldPropertyValueSet = requirement.getProperties();
            if (oldPropertyValueSet != null) {
                this.migrateOldValues(oldPropertyValueSet, newPropertySet);
            }
            if (oldPropertyValueSet == null) {
                oldPropertyValueSet = Edition.getInstance().getSession().getModelFactory().createPropertyValueSet();
                oldPropertyValueSet.setOwner(requirement);
                oldPropertyValueSet.setType(newPropertySet);
            }
            this.createMissingValues(newPropertySet, oldPropertyValueSet);
        }
    }

    private void migrateOldValues(IPropertyValueSet oldPropertyValueSet, IPropertySet newPropertySet) {
        for (IPropertyValue oldPropertyValue : oldPropertyValueSet.getValue()) {
            boolean foundNewPropertyCorresponding = false;
            String oldPropertyName = oldPropertyValue.getKey().getName();
            for (IProperty newProperty : newPropertySet.getOwned()) {
                if (!newProperty.getName().equals(oldPropertyName)) continue;
                oldPropertyValue.setKey(newProperty);
                foundNewPropertyCorresponding = true;
                break;
            }
            if (foundNewPropertyCorresponding) continue;
            Edition.getInstance().getSession().getModelFactory().deleteElement((IElement)oldPropertyValue);
        }
    }

    private void createMissingValues(IPropertySet newPropertySet, IPropertyValueSet oldPropertyValueSet) {
        for (IProperty newProperty : newPropertySet.getOwned()) {
            boolean defaultValueExists = false;
            for (IPropertyValue propertyValue : oldPropertyValueSet.getValue()) {
                if (!propertyValue.getKey().equals((Object)newProperty)) continue;
                defaultValueExists = true;
                break;
            }
            if (defaultValueExists) continue;
            IPropertyValue newPropertyValue = Edition.getInstance().getSession().getModelFactory().createPropertyValue();
            newPropertyValue.setKey(newProperty);
            newPropertyValue.setOwner(oldPropertyValueSet);
            newPropertyValue.setValue(newProperty.getDefaultValue());
        }
    }

    private void rebuildDisplayedProperties() {
        this.properties.clear();
        this.properties.add("RequirementContainer");
        this.properties.add("Name");
        this.properties.add("Type");
        IPropertySet propertySet = this.theRequirementContainer.getType();
        if (propertySet != null) {
            for (IProperty property : propertySet.getOwned()) {
                if (property.getType().getName().equals("RichText")) continue;
                this.properties.add(property.getName());
            }
        }
        this.properties.add("Text");
    }

    private IPropertyType getAvailableSets() {
        ArrayList<IPropertySet> availableSets = new ArrayList<IPropertySet>();
        String stereotypeFilter = this.getPropertySetStereotypeFilter();
        for (IElement elt : Edition.getInstance().getSession().getModel().findByClass(IPropertySet.class)) {
            IPropertySet propertySet = (IPropertySet)elt;
            if (propertySet.cardExtension() != 0 && !propertySet.isStereotyped(stereotypeFilter)) continue;
            availableSets.add(propertySet);
        }
        ModelElementListType type = new ModelElementListType(true, IPropertySet.class, availableSets);
        return type;
    }

    private String getPropertySetStereotypeFilter() {
        String searchedStereotype = this.theRequirementContainer.isStereotyped("requirement_container") ? "requirement_propertyset" : (this.theRequirementContainer.isStereotyped("goal_container") ? "goal_propertyset" : (this.theRequirementContainer.isStereotyped("business_rule_container") ? "business_rule_propertyset" : "requirement_propertyset"));
        return searchedStereotype;
    }
}

