/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.data.standard.model.uml;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.analyst.IEnumeratedPropertyType;
import com.modeliosoft.modelio.api.model.analyst.IProperty;
import com.modeliosoft.modelio.api.model.analyst.IPropertyEnumerationLitteral;
import com.modeliosoft.modelio.api.model.analyst.IPropertySet;
import com.modeliosoft.modelio.api.model.analyst.IPropertyValue;
import com.modeliosoft.modelio.api.model.analyst.IPropertyValueSet;
import com.modeliosoft.modelio.api.model.analyst.ITerm;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListType;
import com.modeliosoft.modelio.core.ui.ktable.types.MultilineStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.ScopeRichTextType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TermPropertyModel
implements IPropertyModel {
    private final ITerm theTerm;
    private final StringType labelStringType = new StringType(false);
    private final StringType stringType = new StringType(true);
    private final BooleanType booleanType = new BooleanType();
    private final Map<IEnumeratedPropertyType, ListType> listType = new HashMap();
    private final List<String> properties = new ArrayList();

    public TermPropertyModel(ITerm theTerm) {
        this.theTerm = theTerm;
        this.properties.add("Term");
        this.properties.add("Name");
        IPropertySet propertySet = this.theTerm.getOwner().getType();
        if (propertySet != null) {
            for (IProperty property : propertySet.getOwned()) {
                this.properties.add(property.getName());
            }
        }
        this.properties.add("Definition");
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return this.properties.size();
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.properties.get(row);
        }
        if (col == 1) {
            if (row == 0) {
                return "Value";
            }
            if (row == 1) {
                return this.theTerm.getName();
            }
            if (2 <= row && row < this.properties.size() - 1) {
                return this.getPropertyValue(row - 2);
            }
            if (row == this.properties.size() - 1) {
                return this.theTerm.getDefinition();
            }
            return null;
        }
        return null;
    }

    public IPropertyType getTypeAt(int row, int col) {
        if (col == 0) {
            return this.labelStringType;
        }
        if (col == 1) {
            if (row == 0) {
                return this.labelStringType;
            }
            if (row == 1) {
                return this.stringType;
            }
            if (2 <= row && row < this.properties.size() - 1) {
                return this.getPropertyType(row - 2);
            }
            if (row == this.properties.size() - 1) {
                return new MultilineStringType((IModelElement)this.theTerm, (String)this.properties.get(row), true);
            }
            return null;
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        if (col == 0) {
            return;
        }
        if (col == 1) {
            if (row == 0) {
                return;
            }
            if (row == 1) {
                this.theTerm.setName(value.toString());
                return;
            }
            if (2 <= row && row < this.properties.size() - 1) {
                this.setPropertyValue(row - 2, value.toString());
                return;
            }
            if (row == this.properties.size() - 1) {
                this.theTerm.setDefinition(value.toString());
            }
            return;
        }
    }

    public boolean isEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        IElementStatus status = this.theTerm.getElementStatus();
        if (!status.isModifiable()) {
            return false;
        }
        IModelingSession modelingSession = Edition.getInstance().getSession();
        Collection mdacs = modelingSession.getMdacRegistry().getStartedMdacs();
        for (IMdac mdac : mdacs) {
            if (!mdac.getName().equals("Analyst")) continue;
            return true;
        }
        return false;
    }

    private Object getPropertyValue(int propertyIndex) {
        IProperty searchedProperty = (IProperty)this.theTerm.getOwner().getType().getOwned().get(propertyIndex);
        boolean isBooleanProperty = searchedProperty.getType().getName().equals("Boolean");
        boolean isRichTextProperty = searchedProperty.getType().getName().equals("RichText");
        IPropertyValueSet propertyValueSet = this.theTerm.getProperties();
        if (propertyValueSet != null) {
            for (IPropertyValue propertyValue : propertyValueSet.getValue()) {
                String stringValue;
                if (!propertyValue.getKey().equals((Object)searchedProperty) || (stringValue = propertyValue.getValue()) == null) continue;
                if (isBooleanProperty) {
                    return new Boolean(stringValue);
                }
                if (isRichTextProperty) {
                    IExternDocument firstRichNote = null;
                    for (IExternDocument doc : this.theTerm.getDocument()) {
                        if (doc.getType() == null || !doc.getType().getName().equals("term")) continue;
                        List tagValues = doc.getTagValues("editor_column");
                        if (tagValues != null && tagValues.contains(searchedProperty.getIdentifier())) {
                            return doc;
                        }
                        if (firstRichNote != null || !searchedProperty.getName().equals("Description")) continue;
                        firstRichNote = doc;
                    }
                    return firstRichNote;
                }
                return stringValue;
            }
        }
        if (isBooleanProperty) {
            return new Boolean(searchedProperty.getDefaultValue());
        }
        return searchedProperty.getDefaultValue();
    }

    private IPropertyType getPropertyType(int propertyIndex) {
        IProperty property = (IProperty)this.theTerm.getOwner().getType().getOwned().get(propertyIndex);
        com.modeliosoft.modelio.api.model.analyst.IPropertyType propertyType = property.getType();
        if (propertyType instanceof IEnumeratedPropertyType) {
            IEnumeratedPropertyType enumeratedPropertyType = (IEnumeratedPropertyType)propertyType;
            ListType type = (ListType)this.listType.get(enumeratedPropertyType);
            if (type != null) {
                return type;
            }
            ArrayList<String> values = new ArrayList<String>();
            for (IPropertyEnumerationLitteral enumLitteral : enumeratedPropertyType.getLitteral()) {
                values.add(enumLitteral.getName());
            }
            type = new ListType(false, values);
            this.listType.put(enumeratedPropertyType, type);
            return type;
        }
        String propertyName = propertyType.getName();
        if (propertyName.equals("Boolean")) {
            return this.booleanType;
        }
        if (propertyName.equals("MultiText")) {
            return new MultilineStringType((IModelElement)this.theTerm, "Definition", true);
        }
        if (propertyName.equals("Text") || propertyName.equals("Integer") || propertyName.equals("Real") || propertyName.equals("Date")) {
            return this.stringType;
        }
        if (propertyName.equals("RichText")) {
            return new ScopeRichTextType((IModelElement)this.theTerm, true);
        }
        return this.stringType;
    }

    private void setPropertyValue(int propertyIndex, String value) {
        IPropertyValue propertyValue2;
        IModelingSession modelingSession = Edition.getInstance().getSession();
        IProperty property = (IProperty)this.theTerm.getOwner().getType().getOwned().get(propertyIndex);
        IPropertyValueSet propertyValueSet = this.theTerm.getProperties();
        if (propertyValueSet == null) {
            propertyValueSet = modelingSession.getModelFactory().createPropertyValueSet();
            propertyValueSet.setType(this.theTerm.getOwner().getType());
            this.theTerm.setProperties(propertyValueSet);
        }
        for (IPropertyValue propertyValue2 : propertyValueSet.getValue()) {
            if (!propertyValue2.getKey().equals((Object)property)) continue;
            propertyValue2.setValue(value);
            return;
        }
        propertyValue2 = modelingSession.getModelFactory().createPropertyValue();
        propertyValue2.setKey(property);
        propertyValue2.setOwner(propertyValueSet);
        propertyValue2.setValue(value);
    }
}

