/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.tree;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.edition.plugin.Edition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object object) {
        if (object == null) {
            return Collections.EMPTY_LIST.toArray();
        }
        ArrayList elements = new ArrayList();
        if (object instanceof IElement) {
            elements.add(object.getClass());
        }
        if (object instanceof IModelElement) {
            elements.addAll(this.getContributingModules((IModelElement)object));
            elements.addAll((Collection<Class<?>>)((IModelElement)object).getExtension());
        }
        return elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parent) {
        return Collections.EMPTY_LIST.toArray();
    }

    public Object getParent(Object child) {
        return null;
    }

    public boolean hasChildren(Object parent) {
        return false;
    }

    private Collection<IModule> getContributingModules(IModelElement element) {
        TreeSet<IModule> modules = new TreeSet<IModule>();
        IModelingSession session = Edition.getInstance().getSession();
        IMetamodelExtensions metamodelExtensions = session.getModel().getMetamodelExtensions();
        for (ITagType tagType : metamodelExtensions.getTagTypes(element.getClass())) {
            if (tagType.getOwnerReference() == null || tagType.isHidden()) continue;
            IModule m = metamodelExtensions.getModule(tagType);
            if (session.getMdacRegistry().getStartedMdac(m) == null) continue;
            modules.add(metamodelExtensions.getModule(tagType));
        }
        return modules;
    }
}

