/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.tree;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.edition.plugin.Edition;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TreeLabelProvider
extends LabelProvider {
    private Image modulePropertyTableIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.edition", (String)"icons/moduleproptable_16.png").createImage();
    private Image stereotypeDefaultIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.edition", (String)"icons/dot_16.png").createImage();

    public Image getImage(Object element) {
        if (element instanceof IStereotype) {
            return this.getStereotypeImage((IStereotype)element);
        }
        if (element instanceof IModule) {
            return this.modulePropertyTableIcon;
        }
        if (element instanceof Class && IElement.class.isAssignableFrom((Class)element)) {
            return StandardImageService.getMetaclassImage((Class)((Class)element));
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IStereotype) {
            StringBuffer stereotypeLabel = new StringBuffer();
            IStereotype stereotype = (IStereotype)element;
            stereotypeLabel.append("\u00ab ");
            String label = stereotype.getLabel();
            if (!label.isEmpty()) {
                stereotypeLabel.append(label);
            } else {
                stereotypeLabel.append(stereotype.getName());
            }
            stereotypeLabel.append(" \u00bb");
            return stereotypeLabel.toString();
        }
        if (element instanceof IModule) {
            IMdac mdac = Edition.getInstance().getSession().getMdacRegistry().getStartedMdac((IModule)element);
            if (mdac != null) {
                return mdac.getLabel();
            }
            return ((IModule)element).getName();
        }
        if (element instanceof Class && IElement.class.isAssignableFrom((Class)element)) {
            return MetaModelExpert.getMetaclassName((Class)((Class)element)).startsWith("Bpmn") ? "BPMN" : "UML";
        }
        return "?" + element.toString();
    }

    private Image getStereotypeImage(IStereotype stereotype) {
        IMdac mdac;
        IModelingSession session = Edition.getInstance().getSession();
        Image image = null;
        IMetamodelExtensions metamodelExtensions = session.getModel().getMetamodelExtensions();
        IModule module = metamodelExtensions.getModule(stereotype);
        if (module != null && (mdac = session.getMdacRegistry().getLoadedMdac(module)) != null) {
            image = mdac.getImage(stereotype, IMdac.ImageType.ICON);
        }
        return image != null ? image : this.stereotypeDefaultIcon;
    }

    public void dispose() {
        this.modulePropertyTableIcon.dispose();
        this.modulePropertyTableIcon = null;
        this.stereotypeDefaultIcon.dispose();
        this.stereotypeDefaultIcon = null;
        super.dispose();
    }
}

