/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.annotations.view.tree;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.edition.annotations.dnd.NoteDragListener;
import com.modeliosoft.modelio.edition.annotations.view.ModelPropertyView;
import com.modeliosoft.modelio.edition.annotations.view.tree.TreeContentProvider;
import com.modeliosoft.modelio.edition.annotations.view.tree.TreeLabelProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class TreePanel
extends Composite {
    private ModelPropertyView view = null;
    private TreeLabelProvider annotationLabelProvider = null;
    private IElement currentElement = null;
    private IElement lastSelectedType = null;
    private TreeViewer viewer = null;

    public TreePanel(SashForm sash, int style, ModelPropertyView view) {
        super((Composite)sash, style);
        this.view = view;
        this.annotationLabelProvider = new TreeLabelProvider();
        this.createGUI();
    }

    private void createGUI() {
        Composite treeArea = new Composite((Composite)this, 0);
        treeArea.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(treeArea, 2562);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.annotationLabelProvider);
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setAutoExpandLevel(3);
        this.initEditor();
        this.initDragSupport();
        this.hookContextMenu();
    }

    public boolean setFocus() {
        return this.viewer.getControl().setFocus();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.view.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void initEditor() {
        TextCellEditor[] cellEditors = new TextCellEditor[]{new TextCellEditor((Composite)this.viewer.getTree(), 0)};
        this.viewer.setCellEditors((CellEditor[])cellEditors);
        String[] properties = new String[]{"name"};
        this.viewer.setColumnProperties(properties);
    }

    private void initDragSupport() {
        int operations = 3;
        DragSource dragSource = new DragSource(this.viewer.getControl(), operations);
        Transfer[] types = new Transfer[]{PasteElementTransfer.getInstance(), ModelElementTransfer.getInstance()};
        dragSource.setTransfer(types);
        dragSource.addDragListener((DragSourceListener)new NoteDragListener(this.viewer));
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    public void select(IElement target, boolean updateLast) {
        if (this.currentElement == null || target == null) {
            this.viewer.setSelection((ISelection)new TreeSelection(null), false);
            return;
        }
        IElement previousLast = this.lastSelectedType;
        if (target != null) {
            TreePath treePath = new TreePath(new Object[]{target});
            this.viewer.setSelection((ISelection)new TreeSelection(treePath), true);
            if (!updateLast) {
                this.lastSelectedType = previousLast;
            } else {
                this.setLastType((Object)target);
            }
        }
    }

    public void setLastType(Object typeItem) {
        this.lastSelectedType = typeItem instanceof IStereotype ? (IStereotype)typeItem : (typeItem instanceof IModule ? (IModule)typeItem : null);
    }

    public void setInput(IElement typedElement, IElement preselectedTypingElement) {
        if (typedElement != null && typedElement.equals((Object)this.currentElement)) {
            this.viewer.refresh();
        } else {
            this.currentElement = typedElement;
            this.viewer.setInput((Object)this.currentElement);
        }
        if (typedElement != null) {
            if (preselectedTypingElement != null) {
                this.select(preselectedTypingElement, true);
            } else {
                this.select(this.lastSelectedType, true);
                if (this.viewer.getSelection().isEmpty()) {
                    this.select(typedElement, false);
                }
            }
        } else {
            this.select(typedElement, false);
        }
    }

    static /* synthetic */ void access$0(TreePanel treePanel, IMenuManager iMenuManager) {
        treePanel.fillContextMenu(iMenuManager);
    }
}

