/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.texteditors;

import com.modeliosoft.modelio.edition.texteditors.IOEditorListener;
import com.modeliosoft.modelio.edition.texteditors.OEditorInput;
import com.modeliosoft.modelio.edition.texteditors.mdd.MDDDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class ODocumentProvider
extends FileDocumentProvider {
    private long cachedModificationStamp;
    private IOEditorListener saveListener;
    private boolean readonlyMode = true;

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected IDocument createDocument(Object obj) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof OEditorInput) {
            OEditorInput ei = (OEditorInput)element;
            File file = ei.getFile();
            if (overwrite) {
                this.effectiveSave(monitor, file, document, true);
                this.fireDocumentsaved(ei);
                return;
            }
            if (file.exists() && !overwrite) {
                if (file.lastModified() != this.cachedModificationStamp) {
                    String[] tab = new String[]{"Overwrite disk contents", "Reload from disk", "Cancel"};
                    MessageDialog dialog = new MessageDialog(null, "Out of sync file.", null, "This file has been modified outside the editor.", 2, tab, 0);
                    int choice = dialog.open();
                    switch (choice) {
                        case 0: {
                            this.effectiveSave(monitor, file, document, true);
                            this.fireDocumentsaved(ei);
                            break;
                        }
                        case 1: {
                            this.resetDocument((Object)ei);
                            break;
                        }
                    }
                    return;
                }
                this.effectiveSave(monitor, file, document, true);
                this.fireDocumentsaved(ei);
            } else {
                return;
            }
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        return !this.readonlyMode;
    }

    public boolean isReadOnly(Object element) {
        return this.readonlyMode;
    }

    public boolean isStateValidated(Object element) {
        return true;
    }

    protected boolean setDocumentContent(IDocument document, File file) throws CoreException {
        FileReader reader;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            return true;
        }
        try {
            this.setDocumentContent(document, (Reader)reader);
            this.cacheModificationStamp(file.lastModified());
            return true;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "error reading file", (Throwable)e));
        }
    }

    private void setDocumentContent(IDocument document, Reader reader) throws IOException {
        try (BufferedReader in = new BufferedReader(reader);){
            StringBuffer buffer = new StringBuffer(512);
            char[] readBuffer = new char[512];
            int n = in.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            document.set(buffer.toString());
        }
    }

    protected void setupDocument(MDDDocument document) {
    }

    private void writeDocumentContent(IDocument document, Writer writer, IProgressMonitor monitor) throws IOException {
        try (BufferedWriter out = new BufferedWriter(writer);){
            out.write(document.get());
        }
    }

    protected void effectiveSave(IProgressMonitor monitor, File file, IDocument document, boolean overwrite) throws CoreException {
        try {
            file.createNewFile();
            if (file.exists()) {
                if (!file.canWrite()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "file is read-only", null));
                }
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "error creating file", null));
            }
            FileWriter writer = new FileWriter(file);
            this.writeDocumentContent(document, (Writer)writer, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "error when saving file", (Throwable)e));
        }
        this.cacheModificationStamp(file.lastModified());
    }

    protected void fireDocumentsaved(OEditorInput input) {
        if (this.saveListener != null) {
            this.saveListener.documentSaved(input.getModelElement(), input.getFile());
        }
    }

    public void setSaveListener(IOEditorListener saveListener) {
        this.saveListener = saveListener;
    }

    protected void cacheModificationStamp(long stamp) {
        this.cachedModificationStamp = stamp;
    }

    public void setReadonlyMode(boolean readonlyMode) {
        this.readonlyMode = readonlyMode;
    }
}

