/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.texteditors;

import com.modeliosoft.modelio.edition.texteditors.IOEditorListener;
import com.modeliosoft.modelio.edition.texteditors.ODocumentProvider;
import com.modeliosoft.modelio.edition.texteditors.OEditorInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;

public abstract class OEditor
extends TextEditor
implements IPartListener {
    protected IOEditorListener editorListener = null;
    protected ODocumentProvider documentProvider = null;

    public void setFocus() {
        super.setFocus();
    }

    public OEditor() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
        this.configureInsertMode(SMART_INSERT, false);
    }

    public void setEditorListener(IOEditorListener editorListener) {
        this.editorListener = editorListener;
        this.documentProvider.setSaveListener(this.editorListener);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getEditorSite().getPage().addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart arg0) {
    }

    public void partBroughtToTop(IWorkbenchPart arg0) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (this == part && this.editorListener != null) {
            this.editorListener.closed(this);
        }
    }

    public void partDeactivated(IWorkbenchPart arg0) {
    }

    public void partOpened(IWorkbenchPart arg0) {
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setBackgroundColor(true);
        IContextService contextService = (IContextService)this.getEditorSite().getService(IContextService.class);
        contextService.activateContext("com.modeliosoft.modelio.bindings.context.OEditorID");
    }

    public void setReadonlyMode(boolean readonlyMode) {
        ODocumentProvider odp;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof OEditorInput) {
            OEditorInput oei = (OEditorInput)editorInput;
            oei.setReadonlyMode(readonlyMode);
        }
        if ((odp = this.getDocumentProvider()) != null) {
            odp.setReadonlyMode(readonlyMode);
        }
        this.setBackgroundColor(readonlyMode);
        this.updateState(editorInput);
    }

    protected void setBackgroundColor(boolean readonly) {
        if (readonly) {
            this.getSourceViewer().getTextWidget().setBackground(this.getSourceViewer().getTextWidget().getDisplay().getSystemColor(29));
        } else {
            this.getSourceViewer().getTextWidget().setBackground(this.getSourceViewer().getTextWidget().getDisplay().getSystemColor(1));
        }
    }

    public void dispose() {
        this.getEditorSite().getPage().removePartListener((IPartListener)this);
        this.editorListener = null;
        this.documentProvider = null;
        super.dispose();
    }

    public IOEditorListener getEditorListener() {
        return this.editorListener;
    }

    public ODocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public abstract String getID();
}

