/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.texteditors.edition;

import com.modeliosoft.modelio.api.editor.IMDAEditorListener;
import com.modeliosoft.modelio.api.editor.IMDATextEditor;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.edition.texteditors.IOEditorListener;
import com.modeliosoft.modelio.edition.texteditors.ODocumentProvider;
import com.modeliosoft.modelio.edition.texteditors.OEditor;
import com.modeliosoft.modelio.edition.texteditors.OEditorInput;
import java.io.File;
import org.eclipse.core.runtime.CoreException;

public class MDATextEditor
implements IMDATextEditor,
IOEditorListener {
    private IMDAEditorListener listener = null;
    private OEditorInput oInput = null;
    private OEditor editor = null;

    public IModelElement getElement() {
        return this.oInput.getModelElement();
    }

    public File getFile() {
        return this.oInput.getFile();
    }

    public void setListener(IMDAEditorListener listener) {
        this.listener = listener;
    }

    public MDATextEditor(OEditorInput oInput, OEditor editor) {
        this.oInput = oInput;
        this.editor = editor;
        this.listener = null;
        editor.setEditorListener((IOEditorListener)this);
    }

    public OEditor getEditor() {
        return this.editor;
    }

    public void documentSaved(IModelElement element, File file) {
        if (this.listener != null) {
            this.listener.documentSaved((IMDATextEditor)this, element, file);
        }
    }

    public void save() {
        try {
            ODocumentProvider dp = this.editor.getDocumentProvider();
            dp.saveDocument(null, (Object)this.oInput, dp.getDocument((Object)this.oInput), true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        ODocumentProvider dp = this.editor.getDocumentProvider();
        try {
            dp.resetDocument((Object)this.oInput);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isDirty() {
        return this.editor.isDirty();
    }

    public void fireEditorClosed() {
        if (this.listener != null) {
            this.listener.editorClosed((IMDATextEditor)this);
        }
    }

    public void closed(OEditor editor) {
        this.fireEditorClosed();
        this.listener = null;
    }

    public void setReadonlyMode(boolean readOnly) {
        this.editor.setReadonlyMode(readOnly);
    }

    public String getId() {
        return this.editor.getID();
    }
}

