/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.texteditors.mdd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.widgets.Display;

public class MDDDocument
extends Document {
    IDocumentPartitioner stdPartitionner = null;
    IDocumentPartitioner replacePartitionner = null;
    IDocumentPartitioner currentPartitionner = null;

    public void replace(int offset, int length, String text) throws BadLocationException {
        if (length > 0) {
            ITypedRegion[] typedRegions;
            ITypedRegion[] iTypedRegionArray = typedRegions = this.computePartitioning(offset, length);
            int n = typedRegions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion typedRegion = iTypedRegionArray[n2];
                if (!this.isWritablePartition(typedRegion)) {
                    return;
                }
                ++n2;
            }
        }
        if (this.isWritablePosition(offset) && this.isWritablePosition(offset + 1)) {
            super.replace(offset, length, text);
        } else {
            Display.getDefault().beep();
        }
    }

    public void replace(int offset, int length, String text, long timestamp) throws BadLocationException {
        if (length > 0) {
            ITypedRegion[] typedRegions;
            ITypedRegion[] iTypedRegionArray = typedRegions = this.computePartitioning(offset, length);
            int n = typedRegions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion typedRegion = iTypedRegionArray[n2];
                if (!this.isWritablePartition(typedRegion)) {
                    return;
                }
                ++n2;
            }
        }
        if (this.isWritablePosition(offset) && this.isWritablePosition(offset + 1)) {
            this.setCurrentPartionner(this.replacePartitionner);
            super.replace(offset, length, text, timestamp);
            this.setCurrentPartionner(this.stdPartitionner);
        } else {
            Display.getDefault().beep();
        }
    }

    public void defineStdPartitioner(IDocumentPartitioner partitionner) {
        this.stdPartitionner = partitionner;
    }

    public void defineReplacePartitioner(IDocumentPartitioner partitionner) {
        this.replacePartitionner = partitionner;
    }

    public void setCurrentPartionner(IDocumentPartitioner partitionner) {
        if (this.currentPartitionner != null) {
            this.currentPartitionner.disconnect();
        }
        this.currentPartitionner = partitionner;
        this.currentPartitionner.connect((IDocument)this);
        this.setDocumentPartitioner(partitionner);
    }

    protected boolean isWritablePosition(int offset) {
        try {
            return this.isWritablePartition(this.getPartition(offset));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean isWritablePartition(ITypedRegion r) {
        return r.getType() != "_RO" && r.getType() != "_TAG";
    }

    public ITypedRegion getPartition(int offset) throws BadLocationException {
        ITypedRegion partition = null;
        try {
            partition = this.getPartition("__dftl_partitioning", offset, true);
            Assert.isNotNull((Object)partition);
        }
        catch (BadPartitioningException e) {
            Assert.isTrue((boolean)false);
        }
        return partition;
    }
}

