/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.texteditors.mdd.partitions;

import com.modeliosoft.modelio.edition.texteditors.mdd.partitions.MDDPartitionScanner;
import java.util.HashMap;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class KeywordRule
implements IPredicateRule {
    private MDDPartitionScanner _scanner;
    IToken roToken;
    IToken rwToken;
    IToken keywordToken;
    HashMap<String, IToken> keywords;
    private StringBuffer buffer;

    public KeywordRule(IToken roToken, IToken rwToken, IToken keywordToken, MDDPartitionScanner scanner) {
        this.roToken = roToken;
        this.rwToken = rwToken;
        this.keywordToken = keywordToken;
        this._scanner = scanner;
        this.buffer = new StringBuffer();
        this.keywords = new HashMap();
    }

    public void addKeyword(String keyword, IToken token) {
        this.keywords.put(keyword, token);
    }

    public IToken evaluate(ICharacterScanner cscanner, boolean resume) {
        return this.evaluate(cscanner);
    }

    public IToken getSuccessToken() {
        return this.keywordToken;
    }

    public IToken evaluate(ICharacterScanner cscanner) {
        this.buffer.setLength(0);
        int c = cscanner.read();
        if (c != -1 && Character.isLetter(c)) {
            do {
                this.buffer.append((char)c);
            } while ((c = cscanner.read()) != -1 && Character.isLetter(c));
        }
        cscanner.unread();
        String word = this.buffer.toString();
        IToken token = (IToken)this.keywords.get(word);
        if (token == null) {
            int i = this.buffer.length() - 1;
            while (i >= 0) {
                cscanner.unread();
                --i;
            }
            return Token.UNDEFINED;
        }
        return this._scanner.editableArea ? token : this.roToken;
    }
}

