/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.wizard;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.INavigationListener;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.core.model.change.IElementDeletedEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeEvent;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.edition.texteditors.OEditor;
import com.modeliosoft.modelio.edition.wizard.WizardView;
import com.modeliosoft.modelio.edition.wizard.panels.WizardPanelFactory;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;

public class WizardViewDisplay
implements IPickingProvider,
IModelChangeListener,
IStatusChangeListener,
INavigationListener,
ISelectionListener,
IPartListener2 {
    private boolean viewBroughtToTop = false;
    private IModelingSession modelingSession = null;
    private IElement currentInput = null;
    private boolean enabled = true;
    private WizardView wizardView = null;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        block11: {
            List selectedElements;
            if (!this.enabled) {
                return;
            }
            if (part instanceof OEditor) {
                return;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IElement selectedElement = null;
            if (selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).toList()).size() == 1 && selectedElements.get(0) instanceof IAdaptable) {
                IAdaptable selectedAdapter = (IAdaptable)selectedElements.get(0);
                selectedElement = (IElement)selectedAdapter.getAdapter(IElement.class);
            }
            boolean wizardPanelAvailable = false;
            if (selectedElement != null) {
                wizardPanelAvailable = WizardPanelFactory.isWizardPanelAvailable(selectedElement);
            }
            if (wizardPanelAvailable) {
                this.currentInput = selectedElement;
                try {
                    this.wizardView = this.viewBroughtToTop ? (WizardView)page.showView("com.modeliosoft.modelio.edition.WizardViewID", null, 2) : (WizardView)page.showView("com.modeliosoft.modelio.edition.WizardViewID", null, 3);
                    if (!this.wizardView.isStarted()) {
                        this.wizardView.start(selectedElement);
                        break block11;
                    }
                    this.wizardView.setInput(selectedElement);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            } else {
                this.currentInput = null;
                if (this.wizardView != null) {
                    this.viewBroughtToTop = page.isPartVisible((IWorkbenchPart)this.wizardView);
                    if (this.wizardView.isStarted()) {
                        this.wizardView.stop();
                        page.hideView((IViewPart)this.wizardView);
                        this.wizardView = null;
                    }
                }
            }
        }
    }

    public void stop() {
        O.getDefault().getNavigateService().removeNavigationListener((INavigationListener)this);
        this.modelingSession.getModel().removeModelListener((IModelChangeListener)this);
        this.modelingSession.getModel().removeStatusListener((IStatusChangeListener)this);
        O.getDefault().getPickingProviderService().removePickingProvider((IPickingProvider)this);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.currentInput = null;
        if (this.wizardView != null) {
            this.viewBroughtToTop = page.isPartVisible((IWorkbenchPart)this.wizardView);
            this.wizardView.stop();
            page.hideView((IViewPart)this.wizardView);
            this.wizardView = null;
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.modelingSession = null;
    }

    public void start(IModelingSession session) {
        this.modelingSession = session;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
        O.getDefault().getPickingProviderService().addPickingProvider((IPickingProvider)this);
        O.getDefault().getNavigateService().addNavigationListener((INavigationListener)this);
        this.modelingSession.getModel().addModelListener((IModelChangeListener)this);
        this.modelingSession.getModel().addStatusListener((IStatusChangeListener)this);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void beginPicking() {
        this.enabled = false;
    }

    public void endPicking() {
        this.enabled = true;
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        IElementDeletedEvent[] deletedElements = event.getDeleteEvents();
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void statusChanged(IModelingSession session, IStatusChangeEvent event) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void updateToolbar() {
        IContributionItem[] items;
        if (this.wizardView == null) {
            return;
        }
        IContributionItem[] iContributionItemArray = items = this.wizardView.getViewSite().getActionBars().getToolBarManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof CommandContributionItem) {
                CommandContributionItem commandItem = (CommandContributionItem)item;
                commandItem.update();
            }
            ++n2;
        }
    }

    public void navigateTo(IElement target) {
    }

    protected void updatePropertyView(IElementDeletedEvent[] deletedElements) {
        if (this.wizardView == null) {
            return;
        }
        IElement input = this.wizardView.getInput();
        IElementDeletedEvent[] iElementDeletedEventArray = deletedElements;
        int n = deletedElements.length;
        int n2 = 0;
        while (n2 < n) {
            IElementDeletedEvent d = iElementDeletedEventArray[n2];
            if (d.getDeletedElement().equals((Object)input)) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                this.currentInput = null;
                if (this.wizardView != null) {
                    this.viewBroughtToTop = page.isPartVisible((IWorkbenchPart)this.wizardView);
                    this.wizardView.stop();
                    page.hideView((IViewPart)this.wizardView);
                }
                return;
            }
            ++n2;
        }
        if (input != null && !input.isValid()) {
            this.wizardView.setInput(null);
            this.updateToolbar();
            return;
        }
        this.wizardView.refresh();
        this.updateToolbar();
    }
}

