/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.wizard.panels.operation;

import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.core.ui.MetamodelLabels;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.editors.EditorFactory;
import com.modeliosoft.modelio.core.ui.ktable.editors.ElementCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.HybridCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.renderers.RendererFactory;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.GhostType;
import com.modeliosoft.modelio.core.ui.ktable.types.HeaderType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.LabelType;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableDefaultModel;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import java.util.MissingResourceException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class KTableParameterModel
extends KTableDefaultModel {
    private IPropertyModel data = null;
    private RendererFactory rendererFactory = null;
    private EditorFactory editorFactory = null;
    private KTable table = null;
    private KTableCellEditor currentEditor = null;
    private Color oddColor = null;
    private Color evenColor = null;

    public KTableParameterModel(KTable table, IPropertyModel data) {
        this.table = table;
        this.data = data;
        this.oddColor = UIColor.TABLE_ODDROW_BG;
        this.evenColor = UIColor.TABLE_EVENROW_BG;
        this.rendererFactory = new RendererFactory(this.table);
        this.editorFactory = new EditorFactory();
    }

    public KTableCellEditor doGetCellEditor(int col, int row) {
        KTableCellEditor editor = null;
        if (!this.data.isEditable(row, col)) {
            return null;
        }
        Object type = this.data.getTypeAt(row, col);
        editor = this.editorFactory.getEditor((IPropertyType)type);
        if (this.currentEditor != null) {
            if (this.currentEditor instanceof ElementCellEditor) {
                ElementCellEditor elementCellEditor = (ElementCellEditor)this.currentEditor;
                elementCellEditor.forceClose();
            } else if (this.currentEditor instanceof HybridCellEditor) {
                HybridCellEditor hybridCellEditor = (HybridCellEditor)this.currentEditor;
                hybridCellEditor.forceClose();
            }
        }
        this.currentEditor = editor;
        return editor;
    }

    public KTableCellRenderer doGetCellRenderer(int col, int row) {
        DefaultCellRenderer renderer = null;
        Object type = this.data.getTypeAt(row, col);
        renderer = this.rendererFactory.getRenderer((IPropertyType)type);
        if (row > 0 && !(type instanceof GhostType)) {
            renderer.setBackground(this.oddColor);
        } else if (row == this.data.getRowsNumber() - 2) {
            renderer.setBackground(Display.getCurrent().getSystemColor(22));
        } else if (row == this.data.getRowsNumber() - 1) {
            if (col > 3) {
                renderer.setBackground(Display.getCurrent().getSystemColor(22));
            } else {
                renderer.setBackground(this.oddColor);
            }
        }
        return renderer;
    }

    public int doGetColumnCount() {
        return this.data.getColumnNumber();
    }

    public Object doGetContentAt(int col, int row) {
        boolean i18n = false;
        Object value = this.data.getValueAt(row, col);
        String key = null;
        Object label = value;
        IPropertyType type = (IPropertyType)this.data.getTypeAt(row, col);
        if (type instanceof HeaderType || type instanceof GhostType) {
            key = (String)value;
            if (key.startsWith("=")) {
                label = key.substring(1);
                i18n = false;
            } else {
                i18n = true;
            }
        } else if (type instanceof LabelType) {
            key = (String)value;
            i18n = true;
        } else if (row == 1 && col == 1) {
            key = (String)value;
            i18n = true;
        } else if (type instanceof EnumType) {
            key = ((Enum)value).name();
            i18n = true;
        }
        if (i18n) {
            try {
                label = MetamodelLabels.getString((String)key);
            }
            catch (MissingResourceException e) {
                label = value;
            }
        }
        return label;
    }

    public int doGetRowCount() {
        return this.data.getRowsNumber();
    }

    public void doSetContentAt(int col, int row, Object value) {
        this.data.setValueAt(row, col, value);
        this.table.redraw();
    }

    public int getInitialColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 18;
            }
            case 1: {
                return this.getOptimalColumnWidth(column);
            }
            case 2: {
                return this.getOptimalColumnWidth(column);
            }
            case 3: {
                return this.getOptimalColumnWidth(column);
            }
            case 4: {
                return this.getOptimalColumnWidth(column);
            }
            case 5: {
                return this.getOptimalColumnWidth(column);
            }
        }
        return 0;
    }

    public int getInitialRowHeight(int row) {
        if (row == 0) {
            return 22;
        }
        return 18;
    }

    public int getFixedHeaderColumnCount() {
        return 0;
    }

    public int getFixedHeaderRowCount() {
        return 1;
    }

    public int getFixedSelectableColumnCount() {
        return 1;
    }

    public int getFixedSelectableRowCount() {
        return 0;
    }

    public int getRowHeightMinimum() {
        return 10;
    }

    public boolean isColumnResizable(int col) {
        return col > 0;
    }

    public void setColumnWidth(int col, int value) {
        super.setColumnWidth(col, value);
    }

    public boolean isRowResizable(int row) {
        return false;
    }

    public int getColumnWidth(int col) {
        return super.getColumnWidth(col);
    }

    public IPropertyType doGetTypeAt(int col, int row) {
        Object type = this.data.getTypeAt(row, col);
        if (type instanceof IPropertyType) {
            return (IPropertyType)type;
        }
        return null;
    }

    private int getOptimalColumnWidth(int column) {
        if (column >= 0 && column < this.getColumnCount()) {
            int width;
            int optWidth = 5;
            GC gc = new GC((Drawable)this.table);
            int i = 0;
            while (i < this.getFixedHeaderRowCount()) {
                width = this.getCellRenderer(column, i).getOptimalWidth(gc, column, i, this.getContentAt(column, i), true, (KTableModel)this);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            i = 1;
            while (i < 1 + this.getRowCount() - 1) {
                width = this.getCellRenderer(column, i).getOptimalWidth(gc, column, i, this.getContentAt(column, i), true, (KTableModel)this);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            gc.dispose();
            return optWidth;
        }
        return -1;
    }
}

