/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.wizard.panels.operation;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.editors.ModelElementLabelService;
import com.modeliosoft.modelio.edition.annotations.view.data.standard.model.PropertyModelFactory;
import com.modeliosoft.modelio.edition.plugin.Edition;
import com.modeliosoft.modelio.edition.wizard.panels.IWizardPanel;
import com.modeliosoft.modelio.edition.wizard.panels.operation.AddParameterButtonListener;
import com.modeliosoft.modelio.edition.wizard.panels.operation.IOperationPropertyModel;
import com.modeliosoft.modelio.edition.wizard.panels.operation.KTableParameterModel;
import com.modeliosoft.modelio.edition.wizard.panels.operation.MoveDownParameterButtonListener;
import com.modeliosoft.modelio.edition.wizard.panels.operation.MoveUpParameterButtonListener;
import com.modeliosoft.modelio.edition.wizard.panels.operation.OperationNameAreaListener;
import com.modeliosoft.modelio.edition.wizard.panels.operation.OperationPropertyModel;
import com.modeliosoft.modelio.edition.wizard.panels.operation.OperationWizardModel;
import com.modeliosoft.modelio.edition.wizard.panels.operation.OperationWizardPanel;
import com.modeliosoft.modelio.edition.wizard.panels.operation.ParameterPropertyModel;
import com.modeliosoft.modelio.edition.wizard.panels.operation.ParameterTableListener;
import com.modeliosoft.modelio.edition.wizard.panels.operation.RemoveParameterButtonListener;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellSelectionListener;
import de.kupzog.ktable.KTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OperationWizardPanel
implements IWizardPanel {
    private IOperation operation = null;
    private IOperationPropertyModel model = null;
    private OperationNameAreaListener operationNameAreaListener = null;
    private AddParameterButtonListener addParameterButtonListener = null;
    private RemoveParameterButtonListener removeParameterButtonListener = null;
    private ParameterTableListener parameterTableListener = null;
    private MoveUpParameterButtonListener moveUpParameterButtonListener = null;
    private MoveDownParameterButtonListener moveDownParameterButtonListener = null;
    private LayoutChangeListener layoutChangeListener = null;
    private KTable operationTable = null;
    private KTable parametersTable = null;
    private PropertyModelFactory propertyModelFactory = null;
    private Composite area = null;
    private Text nameText = null;
    private Button addButton = null;
    private Button removeButton = null;
    private Button moveUpButton = null;
    private Button moveDownButton = null;
    private Image addImage = StandardImageService.getMetaclassImage((String)"IO", IParameter.class);
    private Image removeImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.edition", (String)"icons/remove_16.png").createImage();
    private Image moveUpImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.edition", (String)"icons/moveup_16.png").createImage();
    private Image moveDownImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.edition", (String)"icons/movedown_16.png").createImage();
    private Text previewText = null;
    private Label returnParameterPropertiesLabel = null;
    private SashForm propertyArea = null;

    public OperationWizardPanel(Composite parent) {
        this.propertyModelFactory = new PropertyModelFactory();
        this.createGUI(parent);
    }

    private void createGUI(Composite parent) {
        this.area = new Composite(parent, 0x100000);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 10;
        this.area.setLayout((Layout)layout);
        this.createNameArea();
        this.createPropertyArea();
        this.createPreviewArea();
    }

    public void disableGUI() {
    }

    public void enableGUI() {
    }

    public Composite getComposite() {
        return this.area;
    }

    public void refresh() {
        this.nameText.setText(this.model.getName());
        this.operationTable.redraw();
        this.parametersTable.redraw();
        ModelElementLabelService labelService = new ModelElementLabelService();
        this.previewText.setText(labelService.getLabel((IElement)this.model.getOperation()));
        if (this.getSelectedParameters().size() > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        if (this.getSelectedParameters().size() > 0 && this.model.getIOParameterSize() > 1) {
            this.moveUpButton.setEnabled(true);
            this.moveDownButton.setEnabled(true);
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
        this.area.layout();
    }

    public void setInput(IElement element) {
        if (element != null) {
            this.operation = (IOperation)element;
            this.model = new OperationWizardModel(this.operation);
            OperationPropertyModel operationPropertyModel = new OperationPropertyModel(this.model);
            KTableModel operationKTableModel = this.propertyModelFactory.getPropertyModel(this.operationTable, element, (IPropertyModel)operationPropertyModel);
            this.operationTable.setModel(operationKTableModel);
            ParameterPropertyModel parameterPropertyModel = new ParameterPropertyModel(this.model);
            KTableParameterModel parameterKTableModel = new KTableParameterModel(this.parametersTable, (IPropertyModel)parameterPropertyModel);
            this.parametersTable.setModel((KTableModel)parameterKTableModel);
            ModelElementLabelService lavelService = new ModelElementLabelService();
            this.previewText.setText(lavelService.getLabel((IElement)this.model.getOperation()));
        } else {
            this.removeListeners();
            this.operationTable.setModel(null);
            this.parametersTable.setModel(null);
        }
    }

    public void start() {
        this.initListeners();
    }

    public void stop() {
        if (this.getComposite().isDisposed()) {
            return;
        }
        this.disableAutoLayout();
        this.removeListeners();
        if (this.removeImage != null) {
            this.removeImage.dispose();
            this.removeImage = null;
        }
        if (this.moveUpImage != null) {
            this.moveUpImage.dispose();
            this.moveUpImage = null;
        }
        if (this.moveDownImage != null) {
            this.moveDownImage.dispose();
            this.moveDownImage = null;
        }
        this.getComposite().dispose();
    }

    private Composite createOperationArea() {
        Composite operationArea = new Composite((Composite)this.propertyArea, 0x100000);
        GridLayout gl_operationArea = new GridLayout(1, false);
        gl_operationArea.marginHeight = 0;
        gl_operationArea.marginWidth = 0;
        gl_operationArea.marginLeft = 3;
        operationArea.setLayout((Layout)gl_operationArea);
        GridData gdOperationArea = new GridData(4, 4, true, true);
        operationArea.setLayoutData((Object)gdOperationArea);
        Composite labelArea = new Composite(operationArea, 0x100000);
        GridLayout gl_labelArea = new GridLayout(2, false);
        gl_labelArea.marginHeight = 0;
        gl_labelArea.marginWidth = 0;
        gl_labelArea.marginLeft = 2;
        labelArea.setLayout((Layout)gl_labelArea);
        GridData gdLabelArea = new GridData(4, 0x1000000, true, false);
        gdLabelArea.heightHint = 21;
        labelArea.setLayoutData((Object)gdLabelArea);
        Label operationPropertiesLabel = new Label(labelArea, 0x100000);
        operationPropertiesLabel.setText(Edition.I18N.getString("OperationPropertyPanel.OperationProperties"));
        GridData gdOperationPropertiesLabel = new GridData(4, 0x1000000, true, false);
        operationPropertiesLabel.setLayoutData((Object)gdOperationPropertiesLabel);
        Composite but = new Composite(labelArea, 0);
        GridData gdRemoveButton = new GridData(131072, 0x1000000, false, false);
        gdRemoveButton.widthHint = 21;
        gdRemoveButton.heightHint = 21;
        but.setLayoutData((Object)gdRemoveButton);
        this.operationTable = new KTable(operationArea, 9572096);
        return this.operationTable;
    }

    private void initListeners() {
        this.operationNameAreaListener = new OperationNameAreaListener(this);
        this.nameText.addKeyListener((KeyListener)this.operationNameAreaListener);
        this.nameText.addFocusListener((FocusListener)this.operationNameAreaListener);
        this.addParameterButtonListener = new AddParameterButtonListener(this);
        this.addButton.addSelectionListener((SelectionListener)this.addParameterButtonListener);
        this.removeParameterButtonListener = new RemoveParameterButtonListener(this);
        this.removeButton.addSelectionListener((SelectionListener)this.removeParameterButtonListener);
        this.moveUpParameterButtonListener = new MoveUpParameterButtonListener(this);
        this.moveUpButton.addSelectionListener((SelectionListener)this.moveUpParameterButtonListener);
        this.moveDownParameterButtonListener = new MoveDownParameterButtonListener(this);
        this.moveDownButton.addSelectionListener((SelectionListener)this.moveDownParameterButtonListener);
        this.parameterTableListener = new ParameterTableListener(this);
        this.parametersTable.addCellSelectionListener((KTableCellSelectionListener)this.parameterTableListener);
        this.parametersTable.addKeyListener((KeyListener)this.parameterTableListener);
    }

    private void createNameArea() {
        Composite nameArea = new Composite(this.area, 0x100000);
        GridLayout gl_nameArea = new GridLayout(2, false);
        gl_nameArea.marginHeight = 0;
        gl_nameArea.marginWidth = 3;
        gl_nameArea.marginTop = 3;
        gl_nameArea.marginLeft = 2;
        nameArea.setLayout((Layout)gl_nameArea);
        GridData gdNameArea = new GridData(4, 128, true, false);
        nameArea.setLayoutData((Object)gdNameArea);
        Label nameLabel = new Label(nameArea, 0x100000);
        nameLabel.setText(Edition.I18N.getString("OperationPropertyPanel.Name"));
        GridData gdNameLabel = new GridData(16384, 0x1000000, false, false);
        nameLabel.setLayoutData((Object)gdNameLabel);
        this.nameText = new Text(nameArea, 2048);
        GridData gdNameText = new GridData(4, 128, true, false);
        this.nameText.setLayoutData((Object)gdNameText);
    }

    private void removeListeners() {
        if (this.operationNameAreaListener != null) {
            this.nameText.removeKeyListener((KeyListener)this.operationNameAreaListener);
            this.nameText.removeFocusListener((FocusListener)this.operationNameAreaListener);
            this.operationNameAreaListener = null;
        }
        if (this.addParameterButtonListener != null) {
            this.addButton.removeSelectionListener((SelectionListener)this.addParameterButtonListener);
            this.addParameterButtonListener = null;
        }
        if (this.removeParameterButtonListener != null) {
            this.removeButton.removeSelectionListener((SelectionListener)this.removeParameterButtonListener);
            this.removeParameterButtonListener = null;
        }
        if (this.parameterTableListener != null) {
            this.parametersTable.removeCellSelectionListener((KTableCellSelectionListener)this.parameterTableListener);
            this.parametersTable.removeKeyListener((KeyListener)this.parameterTableListener);
            this.parameterTableListener = null;
        }
        if (this.moveUpParameterButtonListener != null) {
            this.moveUpButton.removeSelectionListener((SelectionListener)this.moveUpParameterButtonListener);
            this.moveUpParameterButtonListener = null;
        }
        if (this.moveDownParameterButtonListener != null) {
            this.moveDownButton.removeSelectionListener((SelectionListener)this.moveDownParameterButtonListener);
            this.moveDownParameterButtonListener = null;
        }
    }

    private int getOperationTableHeight() {
        int height = 0;
        KTableModel tableModel = this.operationTable.getModel();
        int rowNb = tableModel.getRowCount();
        int row = 0;
        while (row < rowNb) {
            height += tableModel.getRowHeight(row);
            ++row;
        }
        return height;
    }

    private void createPropertyArea() {
        this.propertyArea = new SashForm(this.area, 256);
        GridLayout gl_propertyArea = new GridLayout(1, false);
        gl_propertyArea.marginHeight = 0;
        gl_propertyArea.marginWidth = 0;
        this.propertyArea.setLayout((Layout)gl_propertyArea);
        GridData gdPropertyArea = new GridData(4, 4, true, true);
        this.propertyArea.setLayoutData((Object)gdPropertyArea);
        Composite oTable = this.createOperationArea();
        GridData gdOperationTable = new GridData(4, 4, true, true);
        gdOperationTable.horizontalSpan = 0;
        gdOperationTable.verticalSpan = 0;
        oTable.setLayoutData((Object)gdOperationTable);
        Composite pTable = this.createParametersArea();
        GridData gdParametersTable = new GridData(4, 4, true, true);
        gdParametersTable.horizontalSpan = 0;
        gdParametersTable.verticalSpan = 0;
        pTable.setLayoutData((Object)gdParametersTable);
        this.propertyArea.setWeights(new int[]{30, 70});
        this.layoutChangeListener = new LayoutChangeListener(this);
        this.enableAutoLayout();
    }

    private Composite createParametersArea() {
        Composite parametersArea = new Composite((Composite)this.propertyArea, 0x100000);
        GridLayout gl_parametersArea = new GridLayout(1, false);
        gl_parametersArea.marginHeight = 0;
        gl_parametersArea.marginWidth = 0;
        gl_parametersArea.marginRight = 3;
        parametersArea.setLayout((Layout)gl_parametersArea);
        GridData gdParametersArea = new GridData(4, 4, true, true);
        parametersArea.setLayoutData((Object)gdParametersArea);
        Composite labelArea = new Composite(parametersArea, 0x100000);
        GridLayout gl_labelArea = new GridLayout(5, false);
        gl_labelArea.marginHeight = 0;
        gl_labelArea.marginWidth = 5;
        labelArea.setLayout((Layout)gl_labelArea);
        GridData gdLabelArea = new GridData(4, 0x1000000, true, false);
        gdLabelArea.heightHint = 21;
        labelArea.setLayoutData((Object)gdLabelArea);
        Label parametersPropertiesLabel = new Label(labelArea, 0x100000);
        parametersPropertiesLabel.setText(Edition.I18N.getString("OperationPropertyPanel.ParametersProperties"));
        GridData gdParametersPropertiesLabel = new GridData(4, 0x1000000, true, false);
        parametersPropertiesLabel.setLayoutData((Object)gdParametersPropertiesLabel);
        this.addButton = new Button(labelArea, 0);
        this.addButton.setImage(this.addImage);
        this.addButton.setEnabled(true);
        GridData gdAddButton = new GridData(131072, 0x1000000, false, false);
        gdAddButton.widthHint = 21;
        gdAddButton.heightHint = 21;
        this.addButton.setLayoutData((Object)gdAddButton);
        this.removeButton = new Button(labelArea, 0);
        this.removeButton.setImage(this.removeImage);
        this.removeButton.setEnabled(false);
        GridData gdRemoveButton = new GridData(131072, 0x1000000, false, false);
        gdRemoveButton.widthHint = 21;
        gdRemoveButton.heightHint = 21;
        this.removeButton.setLayoutData((Object)gdRemoveButton);
        this.moveUpButton = new Button(labelArea, 0);
        this.moveUpButton.setImage(this.moveUpImage);
        this.moveUpButton.setEnabled(false);
        GridData gdMoveUpButton = new GridData(131072, 0x1000000, false, false);
        gdMoveUpButton.widthHint = 21;
        gdMoveUpButton.heightHint = 21;
        this.moveUpButton.setLayoutData((Object)gdMoveUpButton);
        this.moveDownButton = new Button(labelArea, 0);
        this.moveDownButton.setImage(this.moveDownImage);
        this.moveDownButton.setEnabled(false);
        GridData gdMoveDownButton = new GridData(131072, 0x1000000, false, false);
        gdMoveDownButton.widthHint = 21;
        gdMoveDownButton.heightHint = 21;
        this.moveDownButton.setLayoutData((Object)gdMoveDownButton);
        this.parametersTable = new KTable(parametersArea, 8523522);
        return this.parametersTable;
    }

    List<IParameter> getSelectedParameters() {
        ArrayList<IParameter> selectedParameters = new ArrayList<IParameter>();
        Point[] points = this.parametersTable.getCellSelection();
        ArrayList<Integer> selectedLines = new ArrayList<Integer>();
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            if (!selectedLines.contains(point.y)) {
                selectedLines.add(point.y);
            }
            ++n2;
        }
        Collections.sort(selectedLines);
        IParameter parameter = null;
        Iterator iterator = selectedLines.iterator();
        while (iterator.hasNext()) {
            int selectedLine = (Integer)iterator.next();
            if (selectedLine <= 1 || (parameter = this.model.getParameter(selectedLine - 2)) == null || selectedParameters.contains(parameter)) continue;
            selectedParameters.add(parameter);
        }
        return selectedParameters;
    }

    Button getAddButton() {
        return this.addButton;
    }

    Button getRemoveButton() {
        return this.removeButton;
    }

    Button getMoveUpButton() {
        return this.moveUpButton;
    }

    Button getMoveDownButton() {
        return this.moveDownButton;
    }

    private void createPreviewArea() {
        Composite previewArea = new Composite(this.area, 0x100000);
        GridLayout gl_nameArea = new GridLayout(2, false);
        gl_nameArea.marginHeight = 0;
        gl_nameArea.marginWidth = 3;
        gl_nameArea.marginTop = 3;
        gl_nameArea.marginLeft = 2;
        previewArea.setLayout((Layout)gl_nameArea);
        GridData gdNameArea = new GridData(4, 128, true, false);
        previewArea.setLayoutData((Object)gdNameArea);
        Label nameLabel = new Label(previewArea, 0x100000);
        nameLabel.setText(Edition.I18N.getString("OperationPropertyPanel.MethodSignature"));
        GridData gdNameLabel = new GridData(16384, 0x1000000, false, false);
        nameLabel.setLayoutData((Object)gdNameLabel);
        this.previewText = new Text(previewArea, 72);
        this.previewText.setForeground(this.previewText.getDisplay().getSystemColor(9));
        GridData gdPreviewText = new GridData(4, 0x1000000, true, false);
        gdPreviewText.horizontalIndent = 5;
        this.previewText.setLayoutData((Object)gdPreviewText);
    }

    void selectParameterRow(int row) {
        Point[] selection = new Point[]{new Point(1, row), new Point(1, row), new Point(2, row), new Point(3, row), new Point(4, row), new Point(5, row)};
        this.parametersTable.setSelection(selection, false);
    }

    boolean isParameterRowSelected(int row) {
        return this.parametersTable.isCellSelected(1, row) && this.parametersTable.isCellSelected(2, row) && this.parametersTable.isCellSelected(3, row) && this.parametersTable.isCellSelected(4, row) && this.parametersTable.isCellSelected(5, row);
    }

    void clearSelectedParameterRow() {
        this.parametersTable.clearSelection();
    }

    void selectParameters(List<IParameter> selectedParameters) {
        int index = -1;
        for (IParameter parameter : selectedParameters) {
            index = this.model.getParameterIndex(parameter);
            if (index == -1) continue;
            this.selectParameterRow(index + 2);
        }
    }

    void clearParametersSelection() {
        this.parametersTable.clearSelection();
    }

    Label getReturnParameterPropertiesLabel() {
        return this.returnParameterPropertiesLabel;
    }

    void changeLayout(ControlEvent theEvent) {
        float hwmin = 0.6f;
        float hwmax = 0.65f;
        Composite comp = (Composite)theEvent.widget;
        comp.layout();
        float ratio = (float)comp.getSize().y / (float)comp.getSize().x;
        if (ratio < hwmin) {
            this.setHorizontalLayout();
        } else if (ratio > hwmax) {
            this.setVerticalLayout();
        }
    }

    public void setHorizontalLayout() {
        this.propertyArea.setOrientation(256);
        new Sash((Composite)this.propertyArea, 2560);
        this.propertyArea.setWeights(new int[]{30, 70});
    }

    public void setVerticalLayout() {
        this.propertyArea.setOrientation(512);
        new Sash((Composite)this.propertyArea, 2304);
        this.propertyArea.setWeights(new int[]{50, 50});
    }

    public void setFocus() {
        this.nameText.setFocus();
    }

    public IElement getInput() {
        return this.operation;
    }

    IOperationPropertyModel getModel() {
        return this.model;
    }

    public void disableAutoLayout() {
        this.area.removeControlListener((ControlListener)this.layoutChangeListener);
    }

    public void enableAutoLayout() {
        this.area.addControlListener((ControlListener)this.layoutChangeListener);
    }

    void editCell(int col, int row) {
        this.parametersTable.setSelection(col, row, true);
        this.parametersTable.openEditorInFocus();
    }

    void selectLastParameterRow() {
        int row = this.model.getIOParameterSize() + 1;
        Point[] selection = new Point[]{new Point(1, row), new Point(1, row), new Point(2, row), new Point(3, row), new Point(4, row), new Point(5, row)};
        this.parametersTable.setSelection(selection, false);
    }
}

