/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.wizard.panels.operation;

import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.model.uml.statik.ObPassingModeEnum;
import com.modeliosoft.modelio.core.model.IElementFilter;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.HeaderType;
import com.modeliosoft.modelio.core.ui.ktable.types.ImageDisplayType;
import com.modeliosoft.modelio.core.ui.ktable.types.LabelType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.edition.wizard.panels.operation.IOperationPropertyModel;
import com.modeliosoft.modelio.edition.wizard.panels.operation.ParameterPropertyModel;
import java.util.ArrayList;

public class ParameterPropertyModel
implements IPropertyModel {
    private IOperationPropertyModel model = null;
    private HeaderType headerType = null;
    private EnumType passingType = null;
    private SingleElementType generalClassType = null;
    private ListStringType cardinalityType = null;
    private LabelType labelType = null;
    private ImageDisplayType parameterImageType = null;
    private ImageDisplayType returnParameterImageType = null;
    private StringType leftStringType = null;

    public ParameterPropertyModel(IOperationPropertyModel model) {
        this.model = model;
        this.headerType = new HeaderType();
        this.labelType = new LabelType();
        this.parameterImageType = new ImageDisplayType(IParameter.class, "IO");
        this.returnParameterImageType = new ImageDisplayType(IParameter.class, "Return");
        this.passingType = new EnumType(false, ObPassingModeEnum.class);
        this.leftStringType = new StringType(true);
        this.leftStringType.setAlignment(16384);
        this.generalClassType = new SingleElementType(true, IGeneralClass.class);
        this.generalClassType.setElementFilter((IElementFilter)new GeneralClassTypeFilter(this));
        this.generalClassType.setDisplayOwner(false);
        ArrayList<String> cardinalityValues = new ArrayList<String>();
        cardinalityValues.add("0..1");
        cardinalityValues.add("1");
        cardinalityValues.add("*");
        this.cardinalityType = new ListStringType(true, cardinalityValues);
    }

    public int getColumnNumber() {
        return 6;
    }

    public int getRowsNumber() {
        return this.model.getIOParameterSize() + 2;
    }

    public Object getTypeAt(int row, int col) {
        if (row == 0) {
            return this.headerType;
        }
        if (row == 1) {
            switch (col) {
                case 0: {
                    return this.returnParameterImageType;
                }
                case 1: {
                    return this.leftStringType;
                }
                case 2: {
                    return this.generalClassType;
                }
                case 3: {
                    return this.cardinalityType;
                }
            }
            return this.labelType;
        }
        switch (col) {
            case 0: {
                return this.parameterImageType;
            }
            case 1: {
                return this.leftStringType;
            }
            case 2: {
                return this.generalClassType;
            }
            case 3: {
                return this.cardinalityType;
            }
            case 4: {
                return this.passingType;
            }
            case 5: {
                return this.leftStringType;
            }
        }
        return null;
    }

    public Object getValueAt(int row, int col) {
        if (row == 0) {
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Type";
                }
                case 3: {
                    return "Card";
                }
                case 4: {
                    return "Passing";
                }
                case 5: {
                    return "Value";
                }
            }
            return "";
        }
        if (row == 1) {
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "ReturnedParameter";
                }
                case 2: {
                    return this.model.getReturnParameterType();
                }
                case 3: {
                    return this.getReturnParameterCardinality();
                }
            }
            return "";
        }
        switch (col) {
            case 0: {
                return "";
            }
            case 1: {
                return this.model.getParameterName(row - 2);
            }
            case 2: {
                return this.model.getParameterType(row - 2);
            }
            case 3: {
                return this.getParameterCardinality(row - 2);
            }
            case 4: {
                return this.model.getParameterPassingMode(row - 2);
            }
            case 5: {
                return this.model.getParameterDefaultValue(row - 2);
            }
        }
        return "";
    }

    private String getParameterCardinality(int index) {
        String multiplicityMax;
        String multiplicityMin = this.model.getParameterMultiplicityMin(index);
        if (multiplicityMin.equals(multiplicityMax = this.model.getParameterMultiplicityMax(index))) {
            return multiplicityMax;
        }
        if (multiplicityMax.equals("*")) {
            return "0..*";
        }
        return String.valueOf(multiplicityMin) + ".." + multiplicityMax;
    }

    public boolean isEditable(int row, int col) {
        if (row < 1) {
            return false;
        }
        if (row == 1) {
            if (col == 2) {
                return this.model.isReturnParameterModifiable();
            }
            if (col == 3) {
                return this.model.getReturnParameter() != null && this.model.isReturnParameterModifiable();
            }
            return false;
        }
        return this.model.isParameterModifiable(row - 2);
    }

    public void setValueAt(int row, int col, Object value) {
        block14: {
            block13: {
                if (row == 0) {
                    return;
                }
                if (row != 1) break block13;
                switch (col) {
                    case 2: {
                        this.model.setReturnParameterType((IGeneralClass)value);
                        break block14;
                    }
                    case 3: {
                        this.setReturnParameterCardinality((String)value);
                        break block14;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    this.model.setParameterName(row - 2, (String)value);
                    break;
                }
                case 2: {
                    this.model.setParameterType(row - 2, (IGeneralClass)value);
                    break;
                }
                case 3: {
                    this.setParameterCardinality(row - 2, (String)value);
                    break;
                }
                case 4: {
                    this.model.setParameterPassingMode(row - 2, (ObPassingModeEnum)value);
                    break;
                }
                case 5: {
                    this.model.setParameterDefaultValue(row - 2, (String)value);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void setParameterCardinality(int index, String value) {
        String[] values = value.split("\\.\\.");
        if (values.length == 1 && values[0].equals("*")) {
            this.model.setParameterMultiplicityMin(index, "0");
            this.model.setParameterMultiplicityMax(index, values[0]);
        } else if (values.length == 1) {
            this.model.setParameterMultiplicityMin(index, values[0]);
            this.model.setParameterMultiplicityMax(index, values[0]);
        } else if (values.length == 2) {
            this.model.setParameterMultiplicityMin(index, values[0]);
            this.model.setParameterMultiplicityMax(index, values[1]);
        }
    }

    private String getReturnParameterCardinality() {
        String multiplicityMax;
        String multiplicityMin = this.model.getReturnParameterMultiplicityMin();
        if (multiplicityMin.equals(multiplicityMax = this.model.getReturnParameterMultiplicityMax())) {
            return multiplicityMax;
        }
        if (multiplicityMax.equals("*")) {
            return "0..*";
        }
        return String.valueOf(multiplicityMin) + ".." + multiplicityMax;
    }

    private void setReturnParameterCardinality(String value) {
        String[] values = value.split("\\.\\.");
        if (values.length == 1 && values[0].equals("*")) {
            this.model.setReturnParameterMultiplicityMin("0");
            this.model.setReturnParameterMultiplicityMax(values[0]);
        } else if (values.length == 1) {
            this.model.setReturnParameterMultiplicityMin(values[0]);
            this.model.setReturnParameterMultiplicityMax(values[0]);
        } else if (values.length == 2) {
            this.model.setReturnParameterMultiplicityMin(values[0]);
            this.model.setReturnParameterMultiplicityMax(values[1]);
        }
    }
}

