/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.diagram.IDiagramManager;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.internal.core.ConfigProperties;
import com.modeliosoft.modelio.core.internal.core.ModelImpl;
import com.modeliosoft.modelio.core.internal.core.NativeModelingSession;
import com.modeliosoft.modelio.core.internal.core.audit.CoreAudit;
import com.modeliosoft.modelio.core.internal.core.audit.ICoreAudit;
import com.modeliosoft.modelio.core.internal.core.factory.UMLFactory;
import com.modeliosoft.modelio.core.internal.core.mdacs.MdacRegistry;
import com.modeliosoft.modelio.core.jni.IAccessManager;
import com.modeliosoft.modelio.core.jni.INativeModelChangeListener;
import com.modeliosoft.modelio.core.jni.INativeModelingSession;
import com.modeliosoft.modelio.core.jni.IProjectPropertiesService;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.IConfigProperties;
import com.modeliosoft.modelio.core.model.IModel;
import com.modeliosoft.modelio.core.plugin.Core;
import com.modeliosoft.modelio.core.transaction.ConcurrentTransactionException;
import com.modeliosoft.modelio.core.transaction.IConcurrentTransactionErrorHandler;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.IUndoManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.transaction.NotCurrentTransactionException;
import com.modeliosoft.modelio.core.transaction.RetryCreateTransactionDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class ModelingSession
implements IModelingSession,
ITransactionManager,
IUndoManager,
IDiagramManager {
    private boolean _isOpen = false;
    private ConfigProperties configProperties = null;
    private UMLFactory factory;
    private CoreAudit iAudit;
    private ModelImpl iModel;
    private IMdacRegistry mdacRegistry;
    private INativeModelingSession nativeSession = null;
    private static Map<Integer, IModelingSession> openedSessions = new HashMap();
    private File projectSpacePath;
    private Deque<ITransaction> transactionStack = new ArrayDeque();
    private IConcurrentTransactionErrorHandler concurrentTransactionHandler = new RetryCreateTransactionDialog();

    public static IModelingSession GetSessionFromElement(IElement el) {
        return (IModelingSession)openedSessions.get(el.getSessionId());
    }

    @Deprecated
    public static IModelingSession GetSessionFromId(int sessionId) {
        return (IModelingSession)openedSessions.get(sessionId);
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
        super.finalize();
    }

    public void close() {
        this.assertIsOpen();
        this.iModel.dispose();
        this.iModel = null;
        this.configProperties.close();
        this.configProperties = null;
        this.iAudit.dispose();
        this.iAudit = null;
        this.mdacRegistry = null;
        openedSessions.remove(this.nativeSession.getId());
        this.nativeSession.close();
        this.nativeSession = null;
        this._isOpen = false;
        this.factory = null;
    }

    public void commit(ITransaction transaction) {
        Core.LOG.info("Committing '" + transaction.getName() + "' transaction.");
        this.assertIsOpen();
        this.checkCurrentTransaction(transaction);
        this.checkValid(transaction);
        if (!this.iAudit.auditTransaction(transaction)) {
            this.rollback(transaction);
            throw new InvalidTransactionException("The '" + transaction.getName() + "' transaction is invalid. The transaction has been cancelled.");
        }
        this.nativeSession.commit(transaction);
        transaction.dispose();
        this.transactionStack.pop();
    }

    /*
     * Unable to fully structure code
     */
    public ITransaction createTransaction(String name) throws ConcurrentTransactionException {
        while (true) {
            try {
                Core.LOG.info("Creating '" + name + "' transaction.");
                this.assertIsOpen();
                t = this.nativeSession.createTransaction(name);
                this.transactionStack.push(t);
                return t;
            }
            catch (InterruptedException e) {
                ex = new ConcurrentTransactionException((ITransaction)this.transactionStack.peek(), e, name);
                if (this.concurrentTransactionHandler.mayRetry(ex)) continue;
                Core.LOG.error((Throwable)ex);
                throw ex;
            }
            catch (TimeoutException e) {
                ex = new ConcurrentTransactionException((ITransaction)this.transactionStack.peek(), e, name);
                if (!this.concurrentTransactionHandler.mayRetry(ex)) ** break;
                continue;
                Core.LOG.error((Throwable)ex);
                throw ex;
            }
            break;
        }
    }

    public IAccessManager getAccessManager() {
        return this.nativeSession.getAccessManager();
    }

    public ICoreAudit getAudit() {
        this.assertIsOpen();
        return this.iAudit;
    }

    public IConfigProperties getConfigProperties() {
        return this.configProperties;
    }

    public IDiagramManager getDiagramManager() {
        return this;
    }

    @Deprecated
    public IElementStatus getElementStatus(IElement element) {
        return element.getElementStatus();
    }

    @Deprecated
    public int getId() {
        return this.nativeSession.getId();
    }

    public IMdacRegistry getMdacRegistry() {
        this.assertIsOpen();
        return this.mdacRegistry;
    }

    public IModel getModel() {
        this.assertIsOpen();
        return this.iModel;
    }

    public IModelFactory getModelFactory() {
        this.assertIsOpen();
        return this.factory;
    }

    public INativeModelingSession getNativeSession() {
        return this.nativeSession;
    }

    public IProjectPropertiesService getProjectPropertiesService() {
        return this.nativeSession.getProjectPropertiesService();
    }

    public File getProjectSpacePath() {
        return this.projectSpacePath;
    }

    public int getRepresentation(IAbstractDiagram diagram) {
        return 0;
    }

    public ITransactionManager getTransactionManager() {
        this.assertIsOpen();
        return this;
    }

    public IUndoManager getUndoManager() {
        this.assertIsOpen();
        return this;
    }

    @Deprecated
    public File getWorkspacePath() {
        return this.projectSpacePath;
    }

    public boolean hasLock() {
        return this.nativeSession.hasLock();
    }

    public boolean hasRedo() {
        this.assertIsOpen();
        return this.nativeSession.hasRedo();
    }

    public boolean hasUndo() {
        this.assertIsOpen();
        return this.nativeSession.hasUndo();
    }

    public boolean isDirty() {
        this.assertIsOpen();
        return this.nativeSession.isDirty();
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public void openProject(File projectPath, String ofpFileName, boolean readonly) throws IOException, IllegalStateException {
        if (this._isOpen) {
            throw new IllegalStateException("The modeling session is already open. You must close it and instanciate another ModelingSession.");
        }
        try {
            File filePath = new File(projectPath, ofpFileName);
            if (!filePath.exists()) {
                throw new FileNotFoundException("'" + filePath.getPath() + "' file or directory not found.");
            }
            this.nativeSession = new NativeModelingSession();
            this.nativeSession.openProject(projectPath, ofpFileName, readonly);
            this._isOpen = true;
            this.iModel = new ModelImpl((IModelingSession)this);
            this.nativeSession.registerNativeModelChangeListener((INativeModelChangeListener)this.iModel);
            this.factory = new UMLFactory((IModel)this.iModel, this.nativeSession.getGenericFactory());
            this.mdacRegistry = new MdacRegistry((IModelingSession)this);
            this.projectSpacePath = projectPath;
            this.iAudit = new CoreAudit(this.nativeSession.getAudit());
            this.configProperties = new ConfigProperties((IModelingSession)this);
            openedSessions.put(this.nativeSession.getId(), this);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public void openProject(File projectPath, String ofpFileName) throws IOException, IllegalStateException {
        if (this._isOpen) {
            throw new IllegalStateException("The modeling session is already open. You must close it and instanciate another ModelingSession.");
        }
        try {
            File filePath = new File(projectPath, ofpFileName);
            if (!filePath.exists()) {
                throw new FileNotFoundException("'" + filePath.getPath() + "' file or directory not found.");
            }
            this.nativeSession = new NativeModelingSession();
            this.nativeSession.openProject(projectPath, ofpFileName);
            this._isOpen = true;
            this.iModel = new ModelImpl((IModelingSession)this);
            this.nativeSession.registerNativeModelChangeListener((INativeModelChangeListener)this.iModel);
            this.factory = new UMLFactory((IModel)this.iModel, this.nativeSession.getGenericFactory());
            this.mdacRegistry = new MdacRegistry((IModelingSession)this);
            this.projectSpacePath = projectPath;
            this.iAudit = new CoreAudit(this.nativeSession.getAudit());
            this.configProperties = new ConfigProperties((IModelingSession)this);
            this.iModel.postInit();
            openedSessions.put(this.nativeSession.getId(), this);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public void redo() {
        this.assertIsOpen();
        this.nativeSession.redo();
    }

    public void rollback(ITransaction transaction) {
        ITransaction t;
        Core.LOG.info("Rollbacking '" + transaction.getName() + "' transaction.");
        this.assertIsOpen();
        if (this.transactionStack.peek() != transaction && !this.transactionStack.contains(transaction)) {
            throw new NotCurrentTransactionException("The '" + transaction.getName() + "' transaction is not in the open transactions stack.");
        }
        do {
            t = (ITransaction)this.transactionStack.peek();
            this.checkValid(t);
            this.nativeSession.rollback(t);
            this.transactionStack.pop();
            t.dispose();
        } while (t != transaction);
    }

    public void save() {
        this.assertIsOpen();
        this.nativeSession.save();
    }

    public void undo() {
        this.assertIsOpen();
        this.nativeSession.undo();
    }

    protected void assertIsOpen() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("The modeling session is not open. It cannot be used");
        }
    }

    private void checkCurrentTransaction(ITransaction transaction) throws NotCurrentTransactionException {
        ITransaction currentTransaction = (ITransaction)this.transactionStack.peek();
        if (currentTransaction != transaction) {
            if (currentTransaction == null) {
                throw new NotCurrentTransactionException("The '" + transaction.getName() + "' transaction is not the current transaction.\n" + "There is currently no open transaction.");
            }
            throw new NotCurrentTransactionException("The '" + transaction.getName() + "' transaction is not the current transaction.\n" + "You must first close the '" + currentTransaction.getName() + "' transaction.");
        }
    }

    private void checkValid(ITransaction t) throws IllegalStateException {
        if (t.getId() == 0L) {
            throw new IllegalStateException("'" + t.getName() + "' transaction is closed.");
        }
    }

    public IConcurrentTransactionErrorHandler setConcurrentTransactionHandler(IConcurrentTransactionErrorHandler concurrentTransactionHandler) {
        IConcurrentTransactionErrorHandler ret = this.concurrentTransactionHandler;
        this.concurrentTransactionHandler = concurrentTransactionHandler;
        return ret;
    }
}

