/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.app.events;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.events.AbortPickingListener;
import com.modeliosoft.modelio.core.app.events.IPickingClient;
import com.modeliosoft.modelio.core.app.events.IPickingClientService;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.core.app.events.IPickingProviderService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;

public class PickingEngine
implements IPickingClientService,
IPickingProviderService {
    private List<IPickingProvider> providers = new ArrayList();
    private IPickingClient currentClient = null;
    private Listener abortPickingListener = new AbortPickingListener();

    public boolean acceptElement(IElement target) {
        if (this.currentClient == null) {
            throw new IllegalStateException("No picking session is open");
        }
        return this.currentClient.acceptElement(target);
    }

    public void addPickingProvider(IPickingProvider provider) {
        this.providers.add(provider);
        if (this.currentClient != null) {
            provider.beginPicking();
        }
    }

    public void beginPicking(IPickingClient client) {
        Display.getCurrent().addFilter(2, this.abortPickingListener);
        if (this.currentClient == null) {
            this.currentClient = client;
            for (IPickingProvider p : this.providers) {
                p.beginPicking();
            }
        } else if (this.currentClient != client) {
            this.currentClient.pickingAborted();
            this.currentClient = client;
        }
    }

    public void endPicking(IPickingClient client) {
        Display.getCurrent().removeFilter(2, this.abortPickingListener);
        if (this.currentClient != client) {
            if (this.currentClient == null) {
                throw new IllegalStateException("No picking session has begun.");
            }
            throw new IllegalStateException("The picking session has been open by '" + this.currentClient.toString() + "'.");
        }
        for (IPickingProvider p : this.providers) {
            p.endPicking();
        }
        this.currentClient = null;
    }

    public void removePickingProvider(IPickingProvider provider) {
        this.providers.remove(provider);
    }

    public boolean setElement(IElement target) {
        if (this.currentClient == null) {
            throw new IllegalStateException("No picking session is open");
        }
        return this.currentClient.setElement(target);
    }

    public void abortPicking() {
        if (this.currentClient != null) {
            this.currentClient.pickingAborted();
            this.endPicking(this.currentClient);
            this.currentClient = null;
        }
    }
}

