/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.documents;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.exml.ExmlFileHelper;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.core.documents.IDocumentEditor;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocumentCreator {
    public static boolean createDocument(IExternDocument docToInitialize) throws IOException {
        DocumentFormat format = O.getDefault().getDocumentFormatsRegistry().getFormat(docToInitialize);
        if (format == null) {
            return false;
        }
        String extension = (String)format.getFileExtensions().iterator().next();
        if (docToInitialize.getPath().isEmpty()) {
            docToInitialize.setPath(ExmlFileHelper.buildDocumentPath((IExternDocument)docToInitialize, (String)extension));
        }
        if (DocumentCreator.createfromTemplate((IExternDocument)docToInitialize, (String)extension)) {
            return true;
        }
        IDocumentEditor editor = format.getEditorProvider();
        if (editor == null || !editor.isUsable()) {
            return false;
        }
        return editor.createEmptyFile((IElement)docToInitialize);
    }

    private static boolean createfromTemplate(IExternDocument docToInitialize, String extension) throws IOException {
        Path defPath;
        FileSystem fs = FileSystems.getDefault();
        IModelingSession session = ModelingSession.GetSessionFromElement((IElement)docToInitialize);
        IExternDocument defDoc = DocumentCreator.getDefaultDocument((IExternDocument)docToInitialize);
        if (defDoc != null) {
            defPath = fs.getPath(session.getProjectSpacePath().getPath(), defDoc.getFile().getPath());
        } else {
            Path dir = fs.getPath(session.getProjectSpacePath().getPath(), ".projectdata", "admin", "documents");
            defPath = DocumentCreator.lookForDefaultFile((Path)dir, (IExternDocument)docToInitialize, (String)extension);
        }
        if (defPath != null) {
            Files.copy(defPath, fs.getPath(session.getProjectSpacePath().getPath(), docToInitialize.getFile().getPath()), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        return false;
    }

    private static IExternDocument getDefaultDocument(IExternDocument docToInitialize) {
        IExternDocumentType docType = docToInitialize.getType();
        for (IExternDocument defDoc : docType.getDocument()) {
            if (!defDoc.getMimeType().equals(docToInitialize.getMimeType()) || !defDoc.getName().equals("default")) continue;
            return defDoc;
        }
        return null;
    }

    private static Path lookForDefaultFile(Path dir, IExternDocument docToInitialize, String extension) {
        String mimeName = DocumentCreator.sanitizeFilename((String)docToInitialize.getMimeType());
        String roleName = DocumentCreator.sanitizeFilename((String)docToInitialize.getType().getName());
        Path f = dir.resolve(String.valueOf(roleName) + "." + mimeName + "." + extension);
        if (Files.isRegularFile(f, new LinkOption[0])) {
            return f;
        }
        f = dir.resolve(String.valueOf(roleName) + "." + extension);
        if (Files.isRegularFile(f, new LinkOption[0])) {
            return f;
        }
        return null;
    }

    private static String sanitizeFilename(String name) {
        return name.replaceAll("[:\\\\/*?|<>]", "_");
    }
}

