/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.documents;

import com.modeliosoft.modelio.core.documents.IDocumentEditor;
import com.modeliosoft.modelio.core.documents.SupportLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class DocumentFormat {
    private String mimeType;
    private String label;
    private IDocumentEditor editorProvider;
    private Collection<String> fileExts;
    private SupportLevel supportLevel;
    private String data;
    private Image icon;
    private ImageDescriptor iconDescriptor;

    public DocumentFormat(String mimeType, String fileExt, SupportLevel supportLevel) {
        this.mimeType = mimeType;
        this.supportLevel = supportLevel;
        if (fileExt == null || fileExt.isEmpty()) {
            this.fileExts = Collections.emptyList();
        } else {
            StringTokenizer t = new StringTokenizer(fileExt, ",; \t\n\r\f");
            this.fileExts = new ArrayList(t.countTokens());
            while (t.hasMoreElements()) {
                this.fileExts.add(t.nextToken());
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.icon != null) {
            this.icon.dispose();
        }
    }

    public String getData() {
        return this.data;
    }

    public IDocumentEditor getEditorProvider() {
        return this.editorProvider;
    }

    public Collection<String> getFileExtensions() {
        return this.fileExts;
    }

    public Image getIcon() {
        if (this.icon == null && this.iconDescriptor != null) {
            this.icon = this.iconDescriptor.createImage();
        }
        return this.icon;
    }

    public ImageDescriptor getIconDescriptor() {
        return this.iconDescriptor;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public SupportLevel getSupportLevel() {
        return this.supportLevel;
    }

    public boolean isUsable() {
        return this.editorProvider.isUsable();
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setEditorProvider(IDocumentEditor editorProvider) {
        this.editorProvider = editorProvider;
    }

    public void setIcon(ImageDescriptor icon) {
        this.iconDescriptor = icon;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return String.valueOf(this.label) + " - " + this.mimeType + " from " + this.editorProvider.getClass().getName();
    }
}

