/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.documents;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.core.documents.DocumentFormatRegistry;
import com.modeliosoft.modelio.core.documents.IDocumentEditor;
import com.modeliosoft.modelio.core.documents.IDocumentFormatRegistry;
import com.modeliosoft.modelio.core.documents.SupportLevel;
import com.modeliosoft.modelio.core.log.LOG;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.osgi.framework.Bundle;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocumentFormatRegistry
implements IDocumentFormatRegistry {
    private IRegistryEventListener listener;
    private Map<String, DocumentFormat> bestFormats;
    private Map<String, DocumentFormat> bestEditableFormats;

    private static IDocumentEditor loadDocumentProvider(IConfigurationElement providerEl) {
        try {
            return (IDocumentEditor)providerEl.createExecutableExtension("class");
        }
        catch (CoreException e) {
            LOG.error((String)"org.modelio.core", (Throwable)e);
            return null;
        }
    }

    public DocumentFormatRegistry() {
        this.init();
    }

    public Collection<DocumentFormat> getAllEditableFormats() {
        if (this.bestFormats == null) {
            this.loadSupportedFormats();
        }
        return this.bestEditableFormats.values();
    }

    public Collection<DocumentFormat> getAllFormats() {
        if (this.bestFormats == null) {
            this.loadSupportedFormats();
        }
        return this.bestFormats.values();
    }

    public DocumentFormat getDocumentFormatForMime(String mimeType) {
        this.getAllFormats();
        return (DocumentFormat)this.bestFormats.get(mimeType);
    }

    public DocumentFormat getFileFormat(File aFile) {
        String path = aFile.getPath();
        String extension = path.substring(path.lastIndexOf(".") + 1);
        DocumentFormat ret = null;
        for (DocumentFormat f : this.getAllFormats()) {
            if (!f.getFileExtensions().contains(extension) || (ret = f).getSupportLevel() != SupportLevel.Primary) continue;
            return ret;
        }
        return ret;
    }

    public DocumentFormat getFormat(IExternDocument target) {
        return this.getDocumentFormatForMime(target.getMimeType());
    }

    void dispose() {
        if (this.listener != null) {
            Platform.getExtensionRegistry().removeListener(this.listener);
            this.listener = null;
        }
    }

    void init() {
        this.listener = new RegistryListener(this);
        Platform.getExtensionRegistry().addListener(this.listener, "org.modelio.documentformatprovider");
    }

    void resetLoadedFormats() {
        this.bestFormats = null;
        this.bestEditableFormats = null;
    }

    private boolean isFirstBest(DocumentFormat a, DocumentFormat b) {
        if (a.isUsable() && !b.isUsable()) {
            return true;
        }
        if (b.isUsable() && !a.isUsable()) {
            return false;
        }
        return a.getSupportLevel() == SupportLevel.Primary;
    }

    private void loadSupportedFormats() {
        IConfigurationElement[] config;
        this.bestFormats = new HashMap();
        this.bestEditableFormats = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.modelio.documentformatprovider");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement providerEl = iConfigurationElementArray[n2];
            IDocumentEditor docProvider = DocumentFormatRegistry.loadDocumentProvider((IConfigurationElement)providerEl);
            if (docProvider != null) {
                boolean providerUsable = docProvider.isUsable();
                IConfigurationElement[] iConfigurationElementArray2 = providerEl.getChildren("format");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement docEl = iConfigurationElementArray2[n4];
                    String mimeType = docEl.getAttribute("mime");
                    String label = docEl.getAttribute("label");
                    String data = docEl.getAttribute("data");
                    String extensions = docEl.getAttribute("extensions");
                    boolean isAlternate = "alternate".equals(docEl.getAttribute("support"));
                    DocumentFormat f = new DocumentFormat(mimeType, extensions, isAlternate ? SupportLevel.Alternate : SupportLevel.Primary);
                    f.setLabel(label);
                    f.setEditorProvider(docProvider);
                    f.setData(data);
                    f.setIcon(this.getIcon(docEl, f));
                    DocumentFormat existing = (DocumentFormat)this.bestFormats.get(f.getMimeType());
                    if (existing == null || this.isFirstBest(f, existing)) {
                        this.bestFormats.put(f.getMimeType(), f);
                        if (providerUsable) {
                            this.bestEditableFormats.put(f.getMimeType(), f);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private ImageDescriptor loadSystemIcon(DocumentFormat f) {
        for (String ext : f.getFileExtensions()) {
            ImageData data;
            Program program = Program.findProgram((String)ext);
            if (program == null || (data = program.getImageData()) == null) continue;
            return ImageDescriptor.createFromImageData((ImageData)data);
        }
        return null;
    }

    private ImageDescriptor getIcon(IConfigurationElement docEl, DocumentFormat f) throws InvalidRegistryObjectException {
        Bundle b;
        URL iconUrl;
        String iconPath = docEl.getAttribute("icon");
        ImageDescriptor desc = null;
        if (iconPath != null && !iconPath.trim().isEmpty() && (iconUrl = FileLocator.find((Bundle)(b = Platform.getBundle((String)docEl.getContributor().getName())), (IPath)new Path(iconPath), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)iconUrl);
        }
        if (desc == null) {
            desc = this.loadSystemIcon(f);
        }
        return desc;
    }
}

