/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.internal.core;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IConfigProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class ConfigProperties
implements IConfigProperties {
    private File configFile = null;
    private Properties configProperties = null;
    private static final String CONFIG_FILE_PATH = ".config/project.prefs";

    public ConfigProperties(IModelingSession modelingSession) {
        this.configFile = new File(modelingSession.getProjectSpacePath(), CONFIG_FILE_PATH);
        this.configProperties = new Properties();
        if (!this.configFile.exists()) {
            try {
                this.configFile.getParentFile().mkdirs();
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.configFile.isFile()) {
            FileInputStream inConfigStream = null;
            try {
                try {
                    inConfigStream = new FileInputStream(this.configFile);
                    this.configProperties.load(inConfigStream);
                }
                catch (FileNotFoundException e) {
                    inConfigStream = null;
                    this.configProperties = null;
                    e.printStackTrace();
                    try {
                        if (inConfigStream != null) {
                            ((InputStream)inConfigStream).close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (IOException e) {
                    inConfigStream = null;
                    this.configProperties = null;
                    e.printStackTrace();
                    try {
                        if (inConfigStream != null) {
                            ((InputStream)inConfigStream).close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (inConfigStream != null) {
                        ((InputStream)inConfigStream).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void close() {
        this.store();
        this.configProperties = null;
        this.configFile = null;
    }

    public void store() {
        if (this.configProperties != null) {
            FileOutputStream outConfigStream = null;
            try {
                try {
                    outConfigStream = new FileOutputStream(this.configFile);
                    this.configProperties.store(outConfigStream, "");
                }
                catch (FileNotFoundException e) {
                    outConfigStream = null;
                    System.err.println("Cannot save project preferences: " + e.toString());
                    try {
                        if (outConfigStream != null) {
                            ((OutputStream)outConfigStream).close();
                        }
                    }
                    catch (IOException e2) {
                        System.err.println("Cannot close project preferences file:");
                        e2.printStackTrace();
                    }
                }
                catch (IOException e) {
                    outConfigStream = null;
                    e.printStackTrace();
                    try {
                        if (outConfigStream != null) {
                            ((OutputStream)outConfigStream).close();
                        }
                    }
                    catch (IOException e3) {
                        System.err.println("Cannot close project preferences file:");
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (outConfigStream != null) {
                        ((OutputStream)outConfigStream).close();
                    }
                }
                catch (IOException e) {
                    System.err.println("Cannot close project preferences file:");
                    e.printStackTrace();
                }
            }
        }
    }

    public String getProperty(String owner, String key) {
        String configKey = String.valueOf(owner) + "." + key;
        return this.configProperties.getProperty(configKey);
    }

    public void setProperty(String owner, String key, String value) {
        String configKey = String.valueOf(owner) + "." + key;
        this.configProperties.setProperty(configKey, value);
    }
}

